package com.cusc.nirvana.user.eiam.converter;

import com.cusc.nirvana.user.eiam.dao.entity.UserOrganPO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 用户组织信息(UserOrgan)表服务接口
 *
 * @author yuy336
 * @since 2022-01-12 15:00:02
 */
@Mapper
public interface UserOrganConverter {

    UserOrganConverter INSTANCE = Mappers.getMapper(UserOrganConverter.class);

    /**
     * Description: do 转 dto
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    UserOrganDTO poToDto(UserOrganPO bean);

    /**
     * Description: dto 转 do
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    UserOrganPO dtoToPo(UserOrganDTO bean);

    /**
     * Description: do list 转 dto list
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    List<UserOrganDTO> poListToDtoList(List<UserOrganPO> list);
}
