package com.cusc.nirvana.user.eiam.converter;

import com.cusc.nirvana.user.eiam.dao.entity.UserPO;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 针对内部员工、生态合作伙伴、分级线下店铺等企业内部用户(User)表服务接口
 *
 * @author yuy336
 * @since 2022-01-19 19:47:57
 */
@Mapper
public interface UserConverter {

    UserConverter INSTANCE = Mappers.getMapper(UserConverter.class);

    /**
     * Description: do 转 dto
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    UserDTO poToDto(UserPO bean);

    /**
     * Description: dto 转 do
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    UserPO dtoToPo(UserDTO bean);

    /**
     * Description: do list 转 dto list
     * <br />
     * CreateDate 2021-11-18 15:21:27
     *
     * @author yuyi
     **/
    List<UserDTO> poListToDtoList(List<UserPO> list);
}
