package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.EiamUrlDTO;
import com.cusc.nirvana.user.eiam.dto.UserDTO;
import com.cusc.nirvana.user.eiam.dto.UserSimpleDTO;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.eiam.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 资源url控制器
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
@Slf4j
@RestController
@RequestMapping("/resource/url")
public class UrlController {

    @Autowired
    IUrlService urlService;

    @Autowired
    private IUserService userService;

    @PostMapping("/queryByUrl")
    @ApiOperation(value = "通过url 和 应用id 查询url对应的id", notes = "通过url 和 应用id 查询url对应的id")
    public Response<Long> queryByUrl(@RequestBody EiamUrlDTO bean) {
        return Response.createSuccess(urlService.queryByUrl(bean));
    }

    @PostMapping("/whiteListToRedis")
    @ApiOperation(value = "初始化白名单", notes = "初始化白名单")
    public Response<Integer> whiteListToRedis() {
        return Response.createSuccess(urlService.whiteListToRedis());
    }

    @PostMapping("/add")
    @ApiOperation(value = "添加url", notes = "添加url")
    public Response<Long> add(@RequestBody EiamUrlDTO bean) {
        return Response.createSuccess(urlService.add(bean));
    }

    @PostMapping("/userRoleResUrlToRedis")
    @ApiOperation(value = "将用户授权的url写入redis", notes = "将用户授权的url写入redis")
    public Response userRoleResUrlToRedis(@RequestBody EiamUrlDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getUserId()) || CuscStringUtils.isEmpty(bean.getApplicationId())
                || CuscStringUtils.isEmpty(bean.getTenantNo())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(), ResponseCode.PARAMETER_NULL.getCode());
        }

        urlService.userRoleResUrlToRedis(bean.getUserId(), bean.getTenantNo(), bean.getApplicationId());
        return Response.createSuccess();
    }

    @PostMapping("/allUserRoleResToRedis")
    @ApiOperation(value = "刷新所有用户的URL至缓存", notes = "刷新所有用户的URL至缓存")
    public Response allUserRoleResToRedis(@RequestBody EiamUrlDTO bean) {
        CommonParamterCheck.appIdAndTenantNoRequired(bean.getApplicationId(), bean.getTenantNo());
        //查询所有用户信息
        UserDTO user = new UserDTO();
        user.setTenantNo(bean.getTenantNo());
        List<UserSimpleDTO> userList = userService.queryListUser(user);
        if (!CollectionUtils.isEmpty(userList)) {
            for (UserSimpleDTO userSimpleDTO : userList) {
                urlService.userRoleResUrlToRedis(userSimpleDTO.getUuid(), bean.getTenantNo(),
                        bean.getApplicationId());
            }
        }
        return Response.createSuccess();
    }
}
