package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.constants.RoleSceneEnum;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.service.IRoleResourceService;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * (RoleResource)表控制层
 *
 * @author yuy336
 * @since 2022-01-18 17:35:23
 */
@RestController
@RequestMapping("/roleResource")
public class RoleResourceController {
    /**
     * 服务对象
     */
    @Autowired
    private IRoleResourceService roleResourceService;

    @Autowired
    private IUrlService urlService;

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response add(@RequestBody RoleResourceDTO bean) {
        if(CuscStringUtils.isEmpty(bean.getRoleId()) || CuscStringUtils.isEmpty(bean.getTenantNo()) || CuscStringUtils.isEmpty(bean.getApplicationId())){
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(roleResourceService.add(bean));
    }

    /**
     * 通过角色批量删除角色与资源的关系
     *
     * @param bean 实体
     * @return 删除结果
     */
    @PostMapping("/deleteBatchRole")
    public Response deleteBatchRole(@RequestBody RoleResourceDTO bean) {
        if (CollectionUtils.isEmpty(bean.getRoleIdList()) || CuscStringUtils.isEmpty(bean.getTenantNo()) || CuscStringUtils.isEmpty(bean.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        for (String roleId : bean.getRoleIdList()) {
            bean.setRoleId(roleId);
            roleResourceService.addBatchResource(bean);
            urlService.roleRelUrlToRedis(roleId, RoleSceneEnum.USER.getCode(), bean.getTenantNo(),
                    bean.getApplicationId());
        }
        return Response.createSuccess(bean.getRoleIdList().size());
    }

    /**
     * 通过主键查询单条数据
     *
     * @param userRole 实体
     * @return 单条数据
     */
    @PostMapping("/queryByList")
    public Response<List<RoleResourceDTO>> queryByList(@RequestBody RoleResourceDTO userRole) {
        return Response.createSuccess(roleResourceService.queryByList(userRole));
    }
}

