package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.*;
import com.cusc.nirvana.user.eiam.service.IResourceService;
import com.cusc.nirvana.user.eiam.service.IRoleService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 资源控制器
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
@Slf4j
@RestController
@RequestMapping("/resource")
public class ResourceController {

    @Autowired
    IResourceService resourceService;
    @Autowired
    IRoleService roleService;

    @PostMapping("/addList")
    @ApiOperation(value = "批量新增", notes = "批量新增")
    public Response addList(@RequestBody ResourceBatchDTO resourceBatch) {
        Response ret = resourceService.addList(resourceBatch);
        return ret;
    }

    @PostMapping("/compareResource")
    @ApiOperation(value = "比对输入和数据库中的资源", notes = "比对输入和数据库中的资源")
    public Response compareResource(@RequestBody List<ResourceTreeDTO> resourceList) {
        resourceService.compareResource(resourceList);
        return Response.createSuccess();
    }

    @PostMapping("/query")
    @ApiOperation(value = "查询资源集合", notes = "查询资源集合")
    public Response<List<ResourceSimpleDTO>> query(@RequestBody ResourceDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return resourceService.query(entity);
    }


    @PostMapping("/queryResourceByRoleId")
    @ApiOperation(value = "通过角色id查询资源信息", notes = "通过角色id查询资源信息")
    public Response<List<ResourceDTO>> queryResourceByRoleId(@RequestBody RoleResourceDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getTenantNo()) || CuscStringUtils.isEmpty(entity.getRoleId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceService.queryResourceByRoleId(entity));
    }

    @PostMapping("/queryResourceByUserId")
    @ApiOperation(value = "通过用户id查询资源信息", notes = "通过用户id查询资源信息")
    public Response<List<ResourceSimpleDTO>> queryResourceByUserId(@RequestBody UserRoleDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getUserId()) || CuscStringUtils.isEmpty(entity.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceService.queryResourceByUserId(entity));
    }

    /**
     * 分页查询ResourceClient.queryResourceByUserId
     *
     * @param bean 筛选条件
     * @return 查询结果
     */
    @PostMapping("/queryByPage")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    public Response<PageResult<ResourceDTO>> queryByPage(@RequestBody ResourceDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceService.queryByPage(bean));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
    @PostMapping("/getByUuid")
    @ApiOperation(value = "通过主键查询单条数据", notes = "通过主键查询单条数据")
    public Response<ResourceDTO> getByUuid(@RequestBody ResourceDTO bean) {
        return Response.createSuccess(resourceService.getByUuid(bean));
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    @ApiOperation(value = "新增数据", notes = "新增数据")
    public Response add(@RequestBody ResourceDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getResourceCode()) || CuscStringUtils.isEmpty(bean.getResourceName())
                || CuscStringUtils.isEmpty(bean.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceService.add(bean));
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    @PostMapping("/update")
    @ApiOperation(value = "新增数据", notes = "新增数据")
    public Response update(@RequestBody ResourceDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getUuid()) || CuscStringUtils.isEmpty(bean.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceService.update(bean));
    }

    /**
     * 删除数据
     *
     * @param resource 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    @ApiOperation(value = "删除数据", notes = "删除数据")
    public Response<Boolean> deleteById(@RequestBody ResourceDTO resource) {
        if (CuscStringUtils.isEmpty(resource.getUuid()) || CuscStringUtils.isEmpty(resource.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceService.deleteById(resource));
    }

    /**
     * 冻结数据
     *
     * @param resource 实体
     * @return 删除是否成功
     */
    @PostMapping("/frozen")
    @ApiOperation(value = "冻结", notes = "冻结")
    public Response frozen(@RequestBody ResourceDTO resource) {
        if (CuscStringUtils.isEmpty(resource.getUuid()) || CuscStringUtils.isEmpty(resource.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceService.frozen(resource));
    }

    /**
     * 解冻数据
     *
     * @param resource 实体
     * @return 删除是否成功
     */
    @PostMapping("/unfreeze")
    @ApiOperation(value = "解冻", notes = "解冻")
    public Response unfreeze(@RequestBody ResourceDTO resource) {
        if (CuscStringUtils.isEmpty(resource.getUuid()) || CuscStringUtils.isEmpty(resource.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(),
                    ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(resourceService.unfreeze(resource));
    }

    /**
     * 生成资源sql
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    @PostMapping("/generateResSql")
    @ApiOperation(value = "生成资源sql", notes = "生成资源sql")
    public Response<List<String>> generateResSql(@RequestBody ResourceDTO bean) {
        return Response.createSuccess(resourceService.generateResSql(bean));
    }

}
