package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dto.OrganizationDTO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.eiam.service.IOrganizationService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 组织机构(Organization)表控制层
 *
 * @author yuy336
 * @since 2022-01-12 14:59:29
 */
@RestController
@RequestMapping("/organization")
public class OrganizationController {
    /**
     * 服务对象
     */
    @Autowired
    private IOrganizationService organizationService;

    /**
     * 分页查询
     *
     * @param organization 筛选条件
     * @return 查询结果
     */
    @PostMapping("/queryByPage")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    public Response<PageResult<OrganizationDTO>> queryByPage(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess(organizationService.queryByPage(organization));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param organization 实体
     * @return 单条数据
     */
   @PostMapping("/getByUuid")
    public Response<OrganizationDTO> getByUuid(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess(this.organizationService.getByUuid(organization));
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param organization 实体
     * @return 单条数据
     */
   @PostMapping("/queryByList")
    public Response<List<OrganizationDTO>> queryByList(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess(this.organizationService.queryByList(organization));
    }

    /**
     * 新增数据
     *
     * @param organization 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response<OrganizationDTO> add(@RequestBody OrganizationDTO organization) {
       return Response.createSuccess(this.organizationService.insert(organization));
    }

    /**
     * 编辑数据
     *
     * @param organization 实体
     * @return 编辑结果
     */
    @PostMapping("/update")
    public Response update(@RequestBody OrganizationDTO organization) {
        this.organizationService.update(organization);
        return Response.createSuccess();
    }

    /**
     * 删除数据
     *
     * @param organization 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    public Response<Boolean> deleteById(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess(organizationService.deleteById(organization));
    }

    /**
     * 冻结数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    @PostMapping("/frozen")
    @ApiOperation(value = "冻结", notes = "冻结")
    public Response frozen(@RequestBody OrganizationDTO bean) {
        return Response.createSuccess(organizationService.frozen(bean));
    }

    /**
     * 解冻数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    @PostMapping("/unfreeze")
    @ApiOperation(value = "解冻", notes = "解冻")
    public Response unfreeze(@RequestBody OrganizationDTO bean) {
        return Response.createSuccess(organizationService.unfreeze(bean));
    }

    /**
     * 通过用户id查询组织集合信息
     *
     * @param bean 实体
     * @return 单条数据
     */
    @PostMapping("/getOrganListByUserId")
    public Response<List<OrganizationDTO>> getOrganListByUserId(@RequestBody UserOrganDTO bean) {
        return Response.createSuccess(organizationService.getOrganListByUserId(bean));
    }
}

