package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dto.DataOperationLogDTO;
import com.cusc.nirvana.user.eiam.service.IDataOperationLogService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * eiam数据操作历史(DataOperationLog)表控制层
 *
 * @author yuy336
 * @since 2022-01-12 15:02:10
 */
@RestController
@RequestMapping("/dataOperationLog")
public class DataOperationLogController {
    /**
     * 服务对象
     */
    @Autowired
    private IDataOperationLogService dataOperationLogService;

    /**
     * 分页查询
     *
     * @param dataOperationLog 筛选条件
     * @return 查询结果
     */
    @PostMapping("/queryByPage")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    public Response<PageResult<DataOperationLogDTO>> queryByPage(@RequestBody DataOperationLogDTO dataOperationLog) {
        return Response.createSuccess(dataOperationLogService.queryByPage(dataOperationLog));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param dataOperationLog 实体
     * @return 单条数据
     */
   @PostMapping("/getByUuid")
    public Response<DataOperationLogDTO> getByUuid(@RequestBody DataOperationLogDTO dataOperationLog) {
        return Response.createSuccess(this.dataOperationLogService.getByUuid(dataOperationLog));
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param dataOperationLog 实体
     * @return 单条数据
     */
   @PostMapping("/queryByList")
    public Response<List<DataOperationLogDTO>> queryByList(@RequestBody DataOperationLogDTO dataOperationLog) {
        return Response.createSuccess(this.dataOperationLogService.queryByList(dataOperationLog));
    }

    /**
     * 新增数据
     *
     * @param dataOperationLog 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response add(@RequestBody DataOperationLogDTO dataOperationLog) {
       this.dataOperationLogService.insert(dataOperationLog);
       return Response.createSuccess();
    }

    /**
     * 编辑数据
     *
     * @param dataOperationLog 实体
     * @return 编辑结果
     */
    @PostMapping("/update")
    public Response update(@RequestBody DataOperationLogDTO dataOperationLog) {
        this.dataOperationLogService.update(dataOperationLog);
        return Response.createSuccess();
    }

    /**
     * 删除数据
     *
     * @param dataOperationLog 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    public Response<Boolean> deleteById(@RequestBody DataOperationLogDTO dataOperationLog) {
        return Response.createSuccess(dataOperationLogService.deleteById(dataOperationLog));
    }

}

