package com.cusc.nirvana.user.ciam.util.cache;

import com.cusc.nirvana.user.util.CuscStringUtils;
import com.google.common.cache.Cache;

/**
 * guava缓存service
 *
 * @author yuy336
 * @create 2021-10-22 15:01
 **/
public interface IGuavaCache<T> {

    /**
     * Description: 设置缓存值
     * Date 2021-10-22 03:01:57
     *
     * @author yuyi
     **/
    default void putGuavaCache(String key, T value){
        if(key == null || value == null){
            return;
        }
        getCache().put(key, value);
    }

    /**
     * Description: 获取缓存值
     * Date 2021-10-22 03:02:25
     *
     * @author yuyi
     **/
    default T getGuavaCache(String key){
        if(CuscStringUtils.isEmpty(key)){
            return null;
        }
        return getCache().getIfPresent(key);
    }

    /**
     * Description: 获取缓存对象
     * <br />
     * CreateDate 2021-11-19 11:44:01
     *
     * @author yuyi
     **/
    Cache<String, T> getCache();
}
