package com.cusc.nirvana.user.ciam.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.cusc.nirvana.common.result.BeanUtilsHelper;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.ciam.constants.ResponseCode;
import com.cusc.nirvana.user.ciam.dao.entity.CiamUserPO;
import com.cusc.nirvana.user.ciam.dto.CiamUserDTO;
import com.cusc.nirvana.user.ciam.service.ICiamUserService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * <p>
 * 终端用户 前端控制器
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-14
 */
@Slf4j
@RestController
@RequestMapping("/user/ciam")
public class CiamUserController {

    @Autowired
    ICiamUserService userService;

    @PostMapping("/add")
    @ApiOperation(value = "新增(add)", notes = "测试demo")
    public Response add(CiamUserDTO entity) {
        try {
            CiamUserPO entity0 = new CiamUserPO();
            BeanUtils.copyProperties(entity, entity0);
            return Response.createSuccess(userService.save(entity0));
        } catch (Exception e) {
            log.error("测试demo,新增方法执行出错，错误信息为:{}", e);
            return Response.createError("服务忙", Collections.emptyList());
        }
    }

    @PostMapping("/update")
    @ApiOperation(value = "更新(update)", notes = "测试demo")
    public Response update(CiamUserDTO entity) {
        try {
            CiamUserPO entity0 = new CiamUserPO();
            BeanUtils.copyProperties(entity, entity0);
            return Response.createSuccess(userService.updateById(entity0));
        } catch (Exception e) {
            log.error("测试demo,更新方法执行出错，错误信息为:{}", e);
            return Response.createError("服务忙", Collections.emptyList());
        }
    }

    @PostMapping("/query")
    @ApiOperation(value = "查询(query)", notes = "测试demo")
    public Response<List<CiamUserDTO>> query() {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.orderByDesc("u_time2");
            queryWrapper.eq("del2", 0);

            List<CiamUserPO> list = userService.list(queryWrapper);

            List<CiamUserDTO> result = BeanUtilsHelper.convert(list, CiamUserDTO.class);

            return Response.createSuccess(result);
        } catch (Exception e) {
            log.error("测试demo,查询方法执行出错，错误信息为:{}", e);
            return Response.createError("服务忙", Collections.emptyList());
        }
    }

    @PostMapping("/get")
    @ApiOperation(value = "查询(get)", notes = "测试demo")
    public Response<CiamUserDTO> get(long id) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq("id", id);
            queryWrapper.eq("del2", 0);

            CiamUserPO record = userService.getOne(queryWrapper);

            CiamUserDTO resp = new CiamUserDTO();
            BeanUtils.copyProperties(record, resp);

            return Response.createSuccess(resp);
        } catch (Exception e) {
            log.error("测试demo,查询方法执行出错，错误信息为:{}", e);
            return Response.createError("服务忙", Collections.emptyList());
        }
    }

    @PostMapping("/page")
    @ApiOperation(value = "分页查询(page)", notes = "测试demo")
    public PageResult<CiamUserDTO> page(long current, long size) {
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.orderByDesc("u_time2");
            queryWrapper.eq("del2", 0);

            Page<CiamUserPO> page = userService.page(new Page<>(current, size), queryWrapper);
            return PageHelper.convert(page, CiamUserDTO.class);
        } catch (Exception e) {
            log.error("测试demo,分页查询方法执行出错，错误信息为:{}", e);
            return PageResult.createError("服务忙");
        }
    }

    @PostMapping("/getByPhone")
    @ApiOperation(value = "通过手机号查询用户信息", notes = "通过手机号查询用户信息")
    public Response<List<CiamUserDTO>> getByPhone(@RequestBody CiamUserDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getPhoneNum())) {
            return Response.createError(ResponseCode.PARAMETER_NOT_NULL.getMsg(),
                    ResponseCode.PARAMETER_NOT_NULL.getCode());
        }

        List<CiamUserDTO> retList = null;
        if (bean.getTenantNo() != null) {
            //有租户，走数据库查询
            CiamUserDTO user = userService.getUserByPhoneTenantNo(bean);
            if (user != null) {
                retList = new ArrayList<>();
                retList.add(user);
            }
        } else {
            //没有租户，走es查询
            //retList = ciamEsService.getUserList(bean);
        }
        return Response.createSuccess(retList);
    }

    @PostMapping("/getByPhoneTenantNo")
    @ApiOperation(value = "通过手机号和租户编号查询用户信息", notes = "通过手机号和租户编号查询用户信息")
    public Response<CiamUserDTO> getByPhoneTenantNo(@RequestBody CiamUserDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getTenantNo()) || CuscStringUtils.isEmpty(bean.getPhoneNum())) {
            return Response.createError(ResponseCode.PARAMETER_NOT_NULL.getMsg(),
                    ResponseCode.PARAMETER_NOT_NULL.getCode());
        }
        return Response.createSuccess(userService.getUserByPhoneTenantNo(bean));
    }

    /**
     * 自助注册，如果有账户就直接登录，没有账户就创建一个账户，然后登录
     * @return
     */
    //@PostMapping("/login")
    //public Response<LoginResponseDTO> login(@RequestBody LoginRequestDTO loginRequestDTO){
    //    return Response.createSuccess(userService.login(loginRequestDTO));
    //}

    /**
     * 实名注册
     *
     * @return
     */
    @PostMapping("/createUser")
    @ApiOperation(value = "实名注册", notes = "创建用户")
    public Response createUser(@RequestBody CiamUserDTO entity) {
        if (CuscStringUtils.isEmpty(entity.getTenantNo()) || CuscStringUtils.isEmpty(entity.getPhoneNum())) {
            return Response.createError(ResponseCode.PARAMETER_NOT_NULL.getMsg(),
                    ResponseCode.PARAMETER_NOT_NULL.getCode());
        }
        return Response.createSuccess(userService.addOrGet(entity));

    }
}
