package com.cusc.nirvana.user.auth.identification.service.impl;

import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.user.auth.common.constants.RedisConstant;
import com.cusc.nirvana.user.auth.identification.service.IRandomIdService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Description: 随机id或随机数业务层
 * <br />
 * CreateDate 2022-01-24 10:32:09
 *
 * @author yuyi
 **/
@Service
@Slf4j
public class RandomIdServiceImpl implements IRandomIdService {

    private static final Logger LOGGER = LoggerFactory.getLogger(RandomIdServiceImpl.class);

    @Autowired
    private CacheFactory cacheFactory;


    @Override
    public String getRequestIdToRedis(String applicationId, int expireTime, String content) {
        String requestId = CuscStringUtils.generateUuid();
        //放redis
        try {
            cacheFactory.getExpireStringService()
                    .setExpireValue(RedisConstant.RANDOM_REQUEST_ID + requestId + "_" + applicationId, content,
                            expireTime);
        } catch (CacheException e) {
            log.error("getRequestIdToRedis 请求reids失败 ：", e);
            return null;
        }
        return requestId;
    }

    @Override
    public boolean existsRequestIdRedis(String requestId, String applicationId) {
        try {
            return cacheFactory.getExpireStringService()
                    .containsKey(RedisConstant.RANDOM_REQUEST_ID + requestId + "_" + applicationId);
        } catch (CacheException e) {
            log.error("getRequestIdToRedis 请求reids失败 ：", e);
        }
        return false;
    }

    @Override
    public boolean delRequestIdRedis(String requestId, String applicationId) {
        try {
            return cacheFactory.getExpireStringService()
                    .delete(RedisConstant.RANDOM_REQUEST_ID + requestId + "_" + applicationId);
        } catch (CacheException e) {
            log.error("getRequestIdToRedis 请求reids失败 ：", e);
        }
        return false;
    }

    @Override
    public String getByRequestId(String requestId, String applicationId) {
        try {
            return cacheFactory.getExpireStringService()
                    .getValue(RedisConstant.RANDOM_REQUEST_ID + requestId + "_" + applicationId, String.class);
        } catch (CacheException e) {
            log.error("getByRequestId 请求reids失败 ：", e);
            return null;
        }
    }
}
