package com.cusc.nirvana.user.auth.identification.login;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateReq;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaCreateResp;
import com.cusc.nirvana.user.auth.identification.dto.CaptchaVerificationReq;
import com.cusc.nirvana.user.auth.identification.service.ICaptchaService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@Slf4j
@RestController
@RequestMapping("/captcha")
public class CaptchaController {

    private static final Logger LOGGER = LoggerFactory.getLogger(CaptchaController.class);

    @Autowired
    private ICaptchaService captchaService;

    @PostMapping("/simpleGraphic")
    @ApiOperation(value = "简单图形验证码", notes = "简单图形验证码")
    public Response<CaptchaCreateResp> simpleGraphic(@RequestBody CaptchaCreateReq captchaReq) {
        if (captchaReq == null || captchaReq.getCaptchaType() == null || captchaReq.getCaptchaHeight() == 0
                || captchaReq.getCaptchaWidth() == 0 || captchaReq.getCaptchaLength() == 0 || CuscStringUtils.isEmpty(captchaReq.getApplicationId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(), ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(captchaService.generateCaptcha(captchaReq));
    }

    @PostMapping("/verificationCaptcha")
    @ApiOperation(value = "验证图形验证码", notes = "验证图形验证码")
    public Response verificationCaptcha(@RequestBody CaptchaVerificationReq bean){
        if (bean == null || CuscStringUtils.isEmpty(bean.getCaptchaValue()) || CuscStringUtils.isEmpty(bean.getRequestId())) {
            return Response.createError(ResponseCode.PARAMETER_NULL.getMsg(), ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess(captchaService.verificationCaptcha(bean));
    }
}
