package com.cusc.nirvana.user.auth.authentication.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.authentication.dto.AccessVerifyReq;
import com.cusc.nirvana.user.auth.authentication.service.AccessAuthService;
import com.cusc.nirvana.user.auth.authentication.service.TokenService;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Description: 访问鉴权
 * <br />
 * CreateDate 2021-11-08 11:48:33
 *
 * @author yuyi
 **/
@Slf4j
@RestController
@RequestMapping("/auth")
public class AccessAuthController {

    @Autowired
    private AccessAuthService accessAuthService;

    @Autowired
    private TokenService tokenService;

    @PostMapping("/getUserByToken")
    @ApiOperation(value = "通过token获取用户信息", notes = "通过token获取用户信息")
    public Response getUserByToken(@RequestBody AccessVerifyReq bean) {
        if (bean == null || CuscStringUtils.isEmpty(bean.getToken())) {
            return Response.createSuccess();
        }
        return Response.createSuccess(accessAuthService.getTokenInfo(bean));
    }

    @PostMapping("/accessVerify")
    @ApiOperation(value = "请求鉴权", notes = "请求鉴权")
    public Response accessVerify(@RequestBody AccessVerifyReq bean) {
        if (bean == null || CuscStringUtils.isEmpty(bean.getToken()) || CuscStringUtils.isEmpty(
                bean.getUrl())) {
            return Response.createError(ResponseCode.AUTHENTICATION_FAIL.getMsg(),
                    ResponseCode.AUTHENTICATION_FAIL.getCode());
        }
        //1.检查token是否有效
        Response<AccessTokenHashDTO> ckTokenResp = accessAuthService.checkToken(bean);
        //当开启url鉴权时，此代码需要开放
        if (!ckTokenResp.isSuccess()) {
            return ckTokenResp;
        }

        //2.url鉴权
        bean.setAppId(ckTokenResp.getData().getAppId());
        bean.setTenantNo(ckTokenResp.getData().getTenantNo());
        boolean checkUrl = accessAuthService.checkUrlAccess(bean, ckTokenResp.getData());
        if (!checkUrl) {
            return Response.createError(ResponseCode.UNAUTHORIZED.getMsg(),
                    ResponseCode.UNAUTHORIZED.getCode());
        }
        //token续期
        tokenService.tokenRenewal(ckTokenResp, bean.getToken());
        return ckTokenResp;
    }

    @PostMapping("/isWhiteList")
    @ApiOperation(value = "判断是否是白名单", notes = "判断是否是白名单")
    public Response isWhiteList(@RequestBody AccessVerifyReq bean) {
        if (bean == null || CuscStringUtils.isEmpty(bean.getServerName()) || CuscStringUtils.isEmpty(
                bean.getUrl())) {
            return Response.createError(ResponseCode.WHITE_LIST_AUTHENTICATION_FAIL.getMsg(),
                    ResponseCode.WHITE_LIST_AUTHENTICATION_FAIL.getCode());
        }

        return Response.createSuccess(accessAuthService.isWhiteList(bean));
    }
}
