/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.util;

import com.cusc.nirvana.user.eiam.constants.PasswordCheckCode;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class PasswordChecker {
    private static final String REG_NUMBER = ".*\\d+.*";
    private static final String REG_UPPERCASE = ".*[A-Z]+.*";
    private static final String REG_LOWERCASE = ".*[a-z]+.*";
    private static final String REG_SYMBOL = ".*[~!@#$%^&*()_+|<>,.?/:;'\\[\\]{}\"]+.*";
    private static final char[][] CHAR_TABLE1 = new char[][]{{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', '\u0000'}, {'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', '\\'}, {'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', '\'', '\u0000', '\u0000'}, {'z', 'x', 'c', 'v', 'b', 'n', 'm', ',', '.', '/', '\u0000', '\u0000', '\u0000'}};
    private static final char[][] CHAR_TABLE2 = new char[][]{{'!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', '\u0000'}, {'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '{', '}', '|'}, {'a', 's', 'd', 'f', 'g', 'h', 'j', 'k', 'l', ':', '\"', '\u0000', '\u0000'}, {'z', 'x', 'c', 'v', 'b', 'n', 'm', '<', '>', '?', '\u0000', '\u0000', '\u0000'}};
    private static List<String> SYSTEM_PASSWORD = PasswordChecker.initSystemPassword();

    public static boolean checkPasswordRule(String password, String username, String phone, String email) {
        if (CuscStringUtils.isEmpty((String)password) || password.length() < 8 || password.length() > 20) {
            throw new CuscUserException(PasswordCheckCode.PASSWORD_LENGTH.getCode() + "", PasswordCheckCode.PASSWORD_LENGTH.getMsg());
        }
        if (CuscStringUtils.isNotEmpty((String)username) && password.toLowerCase().contains(username.toLowerCase())) {
            throw new CuscUserException(PasswordCheckCode.CONTAINS_USER_NAME.getCode() + "", PasswordCheckCode.CONTAINS_USER_NAME.getMsg());
        }
        if (CuscStringUtils.isNotEmpty((String)phone) && password.contains(phone)) {
            throw new CuscUserException(PasswordCheckCode.CONTAINS_USER_NAME.getCode() + "", PasswordCheckCode.CONTAINS_USER_NAME.getMsg());
        }
        if (CuscStringUtils.isNotEmpty((String)email) && password.toLowerCase().contains(email.toLowerCase())) {
            throw new CuscUserException(PasswordCheckCode.CONTAINS_USER_NAME.getCode() + "", PasswordCheckCode.CONTAINS_USER_NAME.getMsg());
        }
        if (PasswordChecker.isContinuousChar((String)password)) {
            throw new CuscUserException(PasswordCheckCode.CONTINUOUS_CHARACTER.getCode() + "", PasswordCheckCode.CONTINUOUS_CHARACTER.getMsg());
        }
        if (PasswordChecker.isKeyBoardContinuousChar((String)password)) {
            throw new CuscUserException(PasswordCheckCode.KEYBOARD_CONTINUOUS_CHARACTERS.getCode() + "", PasswordCheckCode.KEYBOARD_CONTINUOUS_CHARACTERS.getMsg());
        }
        if (SYSTEM_PASSWORD.contains(password)) {
            throw new CuscUserException(PasswordCheckCode.CONTAINS_SYSTEM_PASSWORD.getCode() + "", PasswordCheckCode.CONTAINS_SYSTEM_PASSWORD.getMsg());
        }
        int i = 0;
        if (password.matches(".*\\d+.*")) {
            ++i;
        }
        if (password.matches(".*[a-z]+.*")) {
            ++i;
        }
        if (password.matches(".*[A-Z]+.*")) {
            ++i;
        }
        if (password.matches(".*[~!@#$%^&*()_+|<>,.?/:;'\\[\\]{}\"]+.*")) {
            ++i;
        }
        if (i < 3) {
            throw new CuscUserException(PasswordCheckCode.TOO_LOW_COMPLEXITY.getCode() + "", PasswordCheckCode.TOO_LOW_COMPLEXITY.getMsg());
        }
        return true;
    }

    private static boolean isContinuousChar(String password) {
        char[] chars = password.toCharArray();
        for (int i = 0; i < chars.length - 2; ++i) {
            char n1 = chars[i];
            char n2 = chars[i + 1];
            char n3 = chars[i + 2];
            if (n1 == n2 && n1 == n3) {
                return true;
            }
            if ((n1 + '\u0001' != n2 || n1 + 2 != n3) && (n1 - '\u0001' != n2 || n1 - 2 != n3)) continue;
            return true;
        }
        return false;
    }

    private static boolean isKeyBoardContinuousChar(String password) {
        if (CuscStringUtils.isEmpty((String)password)) {
            return false;
        }
        char[] lpStrChars = password.toLowerCase().toCharArray();
        int nStrLen = lpStrChars.length;
        int[] pRowCharPos = new int[nStrLen];
        int[] pColCharPos = new int[nStrLen];
        for (int i = 0; i < nStrLen; ++i) {
            char chLower = lpStrChars[i];
            pColCharPos[i] = -1;
            for (int nRowTable1Idx = 0; nRowTable1Idx < 4; ++nRowTable1Idx) {
                for (int nColTable1Idx = 0; nColTable1Idx < 13; ++nColTable1Idx) {
                    if (chLower != CHAR_TABLE1[nRowTable1Idx][nColTable1Idx]) continue;
                    pRowCharPos[i] = nRowTable1Idx;
                    pColCharPos[i] = nColTable1Idx;
                }
            }
            if (pColCharPos[i] >= 0) continue;
            for (int nRowTable2Idx = 0; nRowTable2Idx < 4; ++nRowTable2Idx) {
                for (int nColTable2Idx = 0; nColTable2Idx < 13; ++nColTable2Idx) {
                    if (chLower != CHAR_TABLE2[nRowTable2Idx][nColTable2Idx]) continue;
                    pRowCharPos[i] = nRowTable2Idx;
                    pColCharPos[i] = nColTable2Idx;
                }
            }
        }
        for (int j = 1; j <= nStrLen - 2; ++j) {
            if (pRowCharPos[j - 1] == pRowCharPos[j] && pRowCharPos[j] == pRowCharPos[j + 1] && (pColCharPos[j - 1] + 1 == pColCharPos[j] && pColCharPos[j] + 1 == pColCharPos[j + 1] || pColCharPos[j + 1] + 1 == pColCharPos[j] && pColCharPos[j] + 1 == pColCharPos[j - 1])) {
                return true;
            }
            if (pColCharPos[j - 1] != pColCharPos[j] || pColCharPos[j] != pColCharPos[j + 1] || (pRowCharPos[j - 1] + 1 != pRowCharPos[j] || pRowCharPos[j] + 1 != pRowCharPos[j + 1]) && (pRowCharPos[j - 1] - 1 != pRowCharPos[j] || pRowCharPos[j] - 1 != pRowCharPos[j + 1])) continue;
            return true;
        }
        return false;
    }

    private static List<String> initSystemPassword() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add("root");
        ret.add("admin");
        ret.add("mysql");
        ret.add("oracle");
        ret.add("system");
        return ret;
    }
}

