/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.CacheFactory;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.RoleSceneEnum;
import com.cusc.nirvana.user.eiam.converter.UserRoleConverter;
import com.cusc.nirvana.user.eiam.dao.UserRoleDao;
import com.cusc.nirvana.user.eiam.dao.entity.UserRolePO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.service.IUserRoleService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserRoleServiceImpl
extends ServiceImpl<UserRoleDao, UserRolePO>
implements IUserRoleService {
    @Autowired
    private CacheFactory cacheFactory;
    @Autowired
    @Lazy
    private IUrlService urlService;

    @Transactional
    public UserRoleDTO add(UserRoleDTO bean) {
        UserRolePO userRolePO = UserRoleConverter.INSTANCE.dtoToPo(bean);
        this.save((Object)userRolePO);
        this.urlService.userRelRolUrlToRedis(bean.getUserId(), userRolePO.getTenantNo(), userRolePO.getApplicationId());
        return bean;
    }

    @Transactional
    public Response addBatchRole(UserRoleDTO entity) {
        this.deleteByUser(entity);
        ArrayList<UserRolePO> urList = new ArrayList<UserRolePO>();
        if (!CollectionUtils.isEmpty((Collection)entity.getRoleUuidList())) {
            for (String roleUuid : entity.getRoleUuidList()) {
                UserRolePO urDO = new UserRolePO();
                urDO.setUserId(entity.getUserId());
                urDO.setRoleId(roleUuid);
                urDO.setTenantNo(entity.getTenantNo());
                urDO.setApplicationId(entity.getApplicationId());
                urList.add(urDO);
            }
            this.saveBatch(urList);
        }
        this.urlService.userRelRolUrlToRedis(entity.getUserId(), entity.getTenantNo(), entity.getApplicationId());
        return Response.createSuccess((Object)entity.getRoleUuidList().size());
    }

    @Transactional
    public Response deleteByUser(UserRoleDTO entity) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"user_id", (Object)entity.getUserId());
        updateWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getApplicationId()), (Object)"application_id", (Object)entity.getApplicationId());
        UserRolePO urDO = new UserRolePO();
        urDO.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        urDO.setOperator(entity.getOperator());
        this.update((Object)urDO, (Wrapper)updateWrapper);
        this.urlService.userRelRolUrlToRedis(entity.getUserId(), entity.getTenantNo(), entity.getApplicationId());
        return Response.createSuccess((Object)true);
    }

    @Transactional
    public Response deleteByRole(UserRoleDTO entity) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"role_id", (Object)entity.getRoleId());
        updateWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getApplicationId()), (Object)"application_id", (Object)entity.getApplicationId());
        UserRolePO urDO = new UserRolePO();
        urDO.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        urDO.setOperator(entity.getOperator());
        this.update((Object)urDO, (Wrapper)updateWrapper);
        this.urlService.roleRelUrlToRedis(entity.getRoleId(), Integer.valueOf(RoleSceneEnum.USER.getCode()), entity.getTenantNo(), entity.getApplicationId());
        return Response.createSuccess((Object)true);
    }

    public Map<String, Set<String>> queryRoleListByUserId(String userId, String tenantNo, String appId) {
        List urList = ((UserRoleDao)this.baseMapper).queryRoleListByUserId(userId, tenantNo, appId);
        if (CollectionUtils.isEmpty((Collection)urList)) {
            return null;
        }
        HashMap<String, Set<String>> retMap = new HashMap<String, Set<String>>();
        for (UserRolePO tmpBean : urList) {
            HashSet<String> roleSet = (HashSet<String>)retMap.get(tmpBean.getApplicationId());
            if (roleSet == null) {
                roleSet = new HashSet<String>();
                retMap.put(tmpBean.getApplicationId(), roleSet);
            }
            roleSet.add(tmpBean.getRoleId());
        }
        return retMap;
    }

    @Transactional
    public boolean delBatchUser(UserRoleDTO entity) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"user_id", (Object)entity.getUserId());
        updateWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq((Object)"tenant_no", (Object)entity.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty((String)entity.getApplicationId()), (Object)"application_id", (Object)entity.getApplicationId());
        updateWrapper.in(!CollectionUtils.isEmpty((Collection)entity.getUserIdList()), (Object)"user_id", (Collection)entity.getUserIdList());
        UserRolePO urDO = new UserRolePO();
        urDO.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        urDO.setOperator(entity.getOperator());
        this.update((Object)urDO, (Wrapper)updateWrapper);
        this.urlService.roleRelUrlToRedis(entity.getUserId(), Integer.valueOf(RoleSceneEnum.USER.getCode()), entity.getTenantNo(), entity.getApplicationId());
        return true;
    }

    public void updateByUserId(UserRoleDTO dto) {
        UserRolePO updatePo = new UserRolePO();
        updatePo.setRoleId(dto.getRoleId());
        updatePo.setIsDelete(Integer.valueOf(0));
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(UserRolePO::getUserId, (Object)dto.getUserId());
        this.update((Object)updatePo, (Wrapper)query);
    }

    public List<UserRoleDTO> queryListByUserIdList(UserRoleDTO dto) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(UserRolePO::getUserId, new Object[]{dto.getUserId()});
        List list = this.list((Wrapper)query);
        return UserRoleConverter.INSTANCE.poListToDtoList(list);
    }

    public List<UserRoleDTO> queryByList(UserRoleDTO userRole) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"tenant_no", (Object)userRole.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)userRole.getUserId()), (Object)"user_id", (Object)userRole.getUserId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)userRole.getRoleId()), (Object)"role_id", (Object)userRole.getRoleId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)userRole.getApplicationId()), (Object)"application_id", (Object)userRole.getApplicationId());
        List record = this.list((Wrapper)queryWrapper);
        return UserRoleConverter.INSTANCE.poListToDtoList(record);
    }
}

