/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.converter.UserResourceConverter;
import com.cusc.nirvana.user.eiam.dao.UserResourceDao;
import com.cusc.nirvana.user.eiam.dao.entity.UserResourcePO;
import com.cusc.nirvana.user.eiam.dto.UserResourceDTO;
import com.cusc.nirvana.user.eiam.service.IUserResourceService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class UserResourceServiceImpl
extends ServiceImpl<UserResourceDao, UserResourcePO>
implements IUserResourceService {
    public List<UserResourceDTO> queryByList(UserResourceDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return UserResourceConverter.INSTANCE.poListToDtoList(record);
    }

    @Transactional
    public UserResourceDTO insert(UserResourceDTO bean) {
        UserResourcePO userResourcePO = UserResourceConverter.INSTANCE.dtoToPo(bean);
        this.save((Object)userResourcePO);
        return bean;
    }

    @Transactional
    public Integer insertBatchResource(UserResourceDTO bean) {
        bean.setOperator(bean.getCreator());
        this.deleteByUserId(bean);
        ArrayList<UserResourcePO> urList = new ArrayList<UserResourcePO>();
        if (!CollectionUtils.isEmpty((Collection)bean.getResourceIdList())) {
            for (String resourceId : bean.getResourceIdList()) {
                UserResourcePO urDO = new UserResourcePO();
                urDO.setUserId(bean.getUserId());
                urDO.setResourceId(resourceId);
                urDO.setTenantNo(bean.getTenantNo());
                urDO.setApplicationId(bean.getApplicationId());
                urList.add(urDO);
            }
            this.saveBatch(urList);
        }
        return urList.size();
    }

    @Transactional
    public boolean deleteByUserId(UserResourceDTO bean) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"user_id", (Object)bean.getUserId());
        updateWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getApplicationId()), (Object)"application_id", (Object)bean.getApplicationId());
        UserResourcePO urDO = new UserResourcePO();
        urDO.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        urDO.setOperator(bean.getOperator());
        this.update((Object)urDO, (Wrapper)updateWrapper);
        return false;
    }
}

