/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.CacheFactory;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.converter.RoleResourceConverter;
import com.cusc.nirvana.user.eiam.dao.RoleResourceDao;
import com.cusc.nirvana.user.eiam.dao.entity.RoleResourcePO;
import com.cusc.nirvana.user.eiam.dto.RoleDTO;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.service.IRoleResourceService;
import com.cusc.nirvana.user.eiam.service.IRoleService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RoleResourceServiceImpl
extends ServiceImpl<RoleResourceDao, RoleResourcePO>
implements IRoleResourceService {
    private static final Logger log = LoggerFactory.getLogger(RoleResourceServiceImpl.class);
    @Autowired
    private CacheFactory cacheFactory;
    @Autowired
    private IRoleService roleService;

    @Transactional
    public RoleResourceDTO add(RoleResourceDTO entity) {
        List rrList = this.queryByList(entity);
        if (!CollectionUtils.isEmpty((Collection)rrList)) {
            return (RoleResourceDTO)rrList.get(0);
        }
        entity.setUuid(CuscStringUtils.generateUuid());
        RoleResourcePO rrPO = RoleResourceConverter.INSTANCE.dtoToPo(entity);
        this.save((Object)rrPO);
        return entity;
    }

    @Transactional
    public Integer addBatchResource(RoleResourceDTO entity) {
        this.deleteByRoleId(entity);
        ArrayList<RoleResourcePO> rrList = new ArrayList<RoleResourcePO>();
        if (!CollectionUtils.isEmpty((Collection)entity.getResourceUuidList())) {
            RoleDTO role = new RoleDTO();
            role.setUuid(entity.getRoleId());
            role.setTenantNo(entity.getTenantNo());
            role = this.roleService.getByUuid(role);
            if (role == null) {
                throw new CuscUserException(ResponseCode.ROLE_INVALID.getCode(), ResponseCode.ROLE_INVALID.getMsg());
            }
            for (String resourceUuid : entity.getResourceUuidList()) {
                RoleResourcePO rrDO = new RoleResourcePO();
                rrDO.setRoleId(entity.getRoleId());
                rrDO.setResourceId(resourceUuid);
                rrDO.setTenantNo(entity.getTenantNo());
                rrDO.setApplicationId(role.getApplicationId());
                rrDO.setCreator(entity.getCreator());
                rrList.add(rrDO);
            }
            this.saveBatch(rrList);
        }
        return rrList.size();
    }

    @Transactional
    public boolean deleteByRoleId(RoleResourceDTO bean) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"role_id", (Object)bean.getRoleId());
        updateWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getApplicationId()), (Object)"application_id", (Object)bean.getApplicationId());
        RoleResourcePO rrDO = new RoleResourcePO();
        rrDO.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        rrDO.setOperator(bean.getCreator());
        this.update((Object)rrDO, (Wrapper)updateWrapper);
        return true;
    }

    @Transactional
    public boolean deleteBatchRole(RoleResourceDTO bean) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"resource_id", (Object)bean.getResourceId());
        updateWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getApplicationId()), (Object)"application_id", (Object)bean.getApplicationId());
        updateWrapper.in(!CollectionUtils.isEmpty((Collection)bean.getRoleIdList()), (Object)"role_id", (Collection)bean.getRoleIdList());
        RoleResourcePO rrPO = new RoleResourcePO();
        rrPO.setIsDelete(Integer.valueOf(CommonDeleteEnum.DELETED.getCode()));
        rrPO.setOperator(bean.getOperator());
        this.update((Object)rrPO, (Wrapper)updateWrapper);
        return true;
    }

    public List<RoleResourceDTO> queryByList(RoleResourceDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getResourceId()), (Object)"resource_id", (Object)bean.getResourceId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getRoleId()), (Object)"role_id", (Object)bean.getRoleId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)bean.getApplicationId()), (Object)"application_id", (Object)bean.getApplicationId());
        List record = this.list((Wrapper)queryWrapper);
        return RoleResourceConverter.INSTANCE.poListToDtoList(record);
    }
}

