/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.converter.ResourceTempalteConverter;
import com.cusc.nirvana.user.eiam.dao.ResourceTempalteDao;
import com.cusc.nirvana.user.eiam.dao.entity.ResourceTempaltePO;
import com.cusc.nirvana.user.eiam.dto.ResourceTempalteDTO;
import com.cusc.nirvana.user.eiam.service.IResourceTempalteService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ResourceTempalteServiceImpl
extends ServiceImpl<ResourceTempalteDao, ResourceTempaltePO>
implements IResourceTempalteService {
    public ResourceTempalteDTO getByUuid(ResourceTempalteDTO resourceTempalte) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)resourceTempalte.getUuid());
        queryWrapper.eq((Object)"is_delete", (Object)0);
        ResourceTempaltePO record = (ResourceTempaltePO)this.getOne((Wrapper)queryWrapper);
        return ResourceTempalteConverter.INSTANCE.poToDto(record);
    }

    public List<ResourceTempalteDTO> queryByList(ResourceTempalteDTO resourceTempalte) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)resourceTempalte.getApplicationId()), (Object)"application_id", (Object)resourceTempalte.getApplicationId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)resourceTempalte.getRoleCode()), (Object)"role_code", (Object)resourceTempalte.getRoleCode());
        queryWrapper.eq(CuscStringUtils.isNotEmpty((String)resourceTempalte.getResourceId()), (Object)"resource_id", (Object)resourceTempalte.getResourceId());
        List record = this.list((Wrapper)queryWrapper);
        return ResourceTempalteConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<ResourceTempalteDTO> queryByPage(ResourceTempalteDTO resourceTempalte) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)0);
        Page page = (Page)this.page((IPage)new Page((long)resourceTempalte.getCurrPage().intValue(), (long)resourceTempalte.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, ResourceTempalteDTO.class);
    }

    @Transactional
    public ResourceTempalteDTO insert(ResourceTempalteDTO resourceTempalte) {
        ResourceTempaltePO resourceTempaltePO = ResourceTempalteConverter.INSTANCE.dtoToPo(resourceTempalte);
        this.save((Object)resourceTempaltePO);
        return resourceTempalte;
    }

    @Transactional
    public ResourceTempalteDTO update(ResourceTempalteDTO resourceTempalte) {
        ResourceTempaltePO resourceTempaltePO = this.getPoByUuid(resourceTempalte.getUuid());
        this.updateById((Object)resourceTempaltePO);
        return resourceTempalte;
    }

    @Transactional
    public boolean deleteById(ResourceTempalteDTO resourceTempalte) {
        ResourceTempaltePO resourceTempaltePO = this.getPoByUuid(resourceTempalte.getUuid());
        return this.updateById((Object)resourceTempaltePO);
    }

    public List<String> queryResourceIdList(ResourceTempalteDTO bean) {
        return ((ResourceTempalteDao)this.baseMapper).queryResourceIdList(bean.getApplicationId(), bean.getRoleCode());
    }

    private ResourceTempaltePO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)uuid);
        queryWrapper.eq((Object)"is_delete", (Object)0);
        return (ResourceTempaltePO)this.getOne((Wrapper)queryWrapper);
    }
}

