/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.cache.CacheFactory;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.config.SmsPropertyConfig;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.eiam.dto.SmsResponseDTO;
import com.cusc.nirvana.user.eiam.dto.SmsSendConfig;
import com.cusc.nirvana.user.eiam.dto.SmsSendDTO;
import com.cusc.nirvana.user.eiam.service.IEiamSmsService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.DateUtils;
import com.cusc.nirvana.user.util.RestTemplateUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class EiamSmsServiceImpl
implements IEiamSmsService {
    private static final Logger log = LoggerFactory.getLogger(EiamSmsServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(EiamSmsServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private SmsPropertyConfig smsPropertyConfig;
    @Autowired
    private CacheFactory cacheFactory;

    public SmsResponseDTO sendSms(String phone, List<String> paramterList, SmsSendConfig config) {
        Response retResp;
        SmsSendDTO send = new SmsSendDTO();
        send.setAccesskey(config.getSmsPlatformKey());
        ArrayList<String> phoneList = new ArrayList<String>();
        phoneList.add(phone);
        send.setPhoneNumbers(phoneList);
        send.setTemplateParams(paramterList);
        send.setSignatureCode(config.getSmsSignatureCode());
        send.setStrategyCode(config.getStrategyCode());
        send.setTemplateCode(config.getSmsTemplateCode());
        try {
            retResp = RestTemplateUtils.postForResponse((RestTemplate)this.restTemplate, (String)(this.smsPropertyConfig.getSmsUrl() + this.smsPropertyConfig.getSendUrl()), (Object)send, SmsResponseDTO.class, (Object[])new Object[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u77ed\u4fe1\u53d1\u9001\u5931\u8d25\uff1a ", (Throwable)e);
            throw new CuscUserException(ResponseCode.SMS_SEND_ERROR.getCode(), ResponseCode.SMS_SEND_ERROR.getMsg());
        }
        this.saveSmsSendLimitToRedis(phone, config);
        if (retResp != null) {
            return (SmsResponseDTO)retResp.getData();
        }
        return null;
    }

    public SmsResponseDTO sendSms(String phone, String parameter, SmsSendConfig config) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(parameter);
        return this.sendSms(phone, list, config);
    }

    public boolean checkSmsConfigNotNull(SmsSendConfig bean) {
        return bean != null && CuscStringUtils.isNotEmpty((String)bean.getSmsTemplateCode());
    }

    public void checkSmsSendLimit(String phone, SmsSendConfig bean) {
        try {
            boolean isExists;
            Integer smsTotal;
            if (bean.getSmsTotalLimit() != null && bean.getSmsTotalLimit() > 0 && CuscStringUtils.isNotEmpty((String)bean.getTotalLimitKey()) && (smsTotal = (Integer)this.cacheFactory.getExpireStringService().getValue(bean.getTotalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId(), Integer.class)) != null && smsTotal >= bean.getSmsTotalLimit()) {
                throw new CuscUserException(ResponseCode.SMS_TOTAL_LIMIT_OVERRUN.getCode(), ResponseCode.SMS_TOTAL_LIMIT_OVERRUN.getMsg());
            }
            if (bean.getSmsIntervalLimit() != null && bean.getSmsIntervalLimit() > 0 && CuscStringUtils.isNotEmpty((String)bean.getIntervalLimitKey()) && (isExists = this.cacheFactory.getExpireStringService().containsKey(bean.getIntervalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId()).booleanValue())) {
                throw new CuscUserException(ResponseCode.SMS_INTERVAL_LIMIT_OVERRUN.getCode(), ResponseCode.SMS_INTERVAL_LIMIT_OVERRUN.getMsg());
            }
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u77ed\u4fe1\u53d1\u9001\u9650\u5236\u4fe1\u606f\u65f6\u8bbf\u95eeredis \u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    public void convertToSmsConfig(ApplicationDTO fromBean, SmsSendConfig toBean) {
        if (!this.checkSmsConfigNotNull(toBean)) {
            throw new CuscUserException(ResponseCode.SMS_CONFIG_NOT_NULL.getCode(), ResponseCode.SMS_CONFIG_NOT_NULL.getMsg());
        }
        if (toBean.getSmsPlatformKey() == null) {
            if (fromBean.getSmsPlatformKey() == null) {
                log.warn("sms config smsPlatformKey is null");
                throw new CuscUserException(ResponseCode.SMS_CONFIG_NOT_NULL.getCode() + "", ResponseCode.SMS_CONFIG_NOT_NULL.getMsg());
            }
            toBean.setSmsPlatformKey(fromBean.getSmsPlatformKey());
        }
        if (toBean.getSmsSignatureCode() == null) {
            if (fromBean.getSmsSignatureCode() == null) {
                log.warn("sms config smsSignatureCode is null");
                throw new CuscUserException(ResponseCode.SMS_CONFIG_NOT_NULL.getCode() + "", ResponseCode.SMS_CONFIG_NOT_NULL.getMsg());
            }
            toBean.setSmsSignatureCode(fromBean.getSmsSignatureCode());
        }
    }

    private void saveSmsSendLimitToRedis(String phone, SmsSendConfig bean) {
        try {
            if (bean.getSmsTotalLimit() != null && bean.getSmsTotalLimit() > 0 && CuscStringUtils.isNotEmpty((String)bean.getTotalLimitKey())) {
                Long expireTime;
                Integer smsTotal = (Integer)this.cacheFactory.getExpireStringService().getValue(bean.getTotalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId(), Integer.class);
                if (smsTotal == null) {
                    smsTotal = 1;
                    LocalDateTime begin = LocalDateTime.now();
                    expireTime = DateUtils.secondBetween((LocalDateTime)begin, (LocalDateTime)DateUtils.getDayEnd((LocalDateTime)begin));
                } else {
                    Integer n = smsTotal;
                    Integer n2 = smsTotal = Integer.valueOf(smsTotal + 1);
                    expireTime = this.cacheFactory.getExpireStringService().getKeyExpireTime(bean.getTotalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId());
                }
                this.cacheFactory.getExpireStringService().setExpireValue(bean.getTotalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId(), (Object)smsTotal, expireTime.intValue());
            }
            if (bean.getSmsIntervalLimit() != null && bean.getSmsIntervalLimit() > 0 && CuscStringUtils.isNotEmpty((String)bean.getIntervalLimitKey())) {
                this.cacheFactory.getExpireStringService().setExpireValue(bean.getIntervalLimitKey() + phone + "_" + bean.getTenantNo() + "_" + bean.getAppId(), (Object)1, bean.getSmsIntervalLimit().intValue());
            }
        }
        catch (Exception e) {
            log.error("\u4fdd\u5b58\u77ed\u4fe1\u53d1\u9001\u9650\u5236\u4fe1\u606f\u5230redis \u5f02\u5e38\uff1a", (Throwable)e);
        }
    }
}

