/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.constants.CommonStatusEnum;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.converter.ApplicationConverter;
import com.cusc.nirvana.user.eiam.dao.ApplicationDao;
import com.cusc.nirvana.user.eiam.dao.entity.ApplicationPO;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import com.cusc.nirvana.user.eiam.service.IApplicationService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApplicationServiceImpl
extends ServiceImpl<ApplicationDao, ApplicationPO>
implements IApplicationService {
    @Autowired
    private CacheFactory cacheFactory;

    public ApplicationDTO getById(ApplicationDTO application) {
        ApplicationPO record = this.getPoById(application.getId());
        return ApplicationConverter.INSTANCE.poToDto(record);
    }

    public List<ApplicationDTO> queryByList(ApplicationDTO application) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.orderByDesc((Object)"create_time");
        List record = this.list((Wrapper)queryWrapper);
        return ApplicationConverter.INSTANCE.poListToDtoList(record);
    }

    public PageResult<ApplicationDTO> queryByPage(ApplicationDTO application) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc((Object)"create_time");
        queryWrapper.eq((Object)"is_delete", (Object)0);
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)application.getApplicationCode()), (Object)"application_code", (Object)application.getApplicationCode());
        queryWrapper.like(CuscStringUtils.isNotEmpty((String)application.getApplicationName()), (Object)"application_name", (Object)application.getApplicationName());
        Page page = (Page)this.page((IPage)new Page((long)application.getCurrPage().intValue(), (long)application.getPageSize().intValue()), (Wrapper)queryWrapper);
        return PageHelper.convert((Page)page, ApplicationDTO.class);
    }

    @Transactional
    public ApplicationDTO insert(ApplicationDTO application) {
        ApplicationPO applicationPO = ApplicationConverter.INSTANCE.dtoToPo(application);
        this.save((Object)applicationPO);
        return application;
    }

    @Transactional
    public ApplicationDTO update(ApplicationDTO application) {
        ApplicationPO applicationPO = this.getPoById(application.getId());
        if (applicationPO == null) {
            return null;
        }
        ApplicationPO tmpBean = ApplicationConverter.INSTANCE.dtoToPo(application);
        this.updateById((Object)tmpBean);
        return application;
    }

    @Transactional
    public boolean deleteById(ApplicationDTO application) {
        ApplicationPO applicationPO = this.getPoById(application.getId());
        if (applicationPO == null) {
            return false;
        }
        return this.updateById((Object)applicationPO);
    }

    @Transactional
    public boolean frozen(ApplicationDTO application) {
        ApplicationPO applicationPO = this.getPoById(application.getId());
        if (applicationPO == null) {
            return false;
        }
        ApplicationPO tmpApp = new ApplicationPO();
        tmpApp.setId(applicationPO.getId());
        tmpApp.setStatus(Integer.valueOf(CommonStatusEnum.DISABLE.getCode()));
        return this.updateById((Object)tmpApp);
    }

    @Transactional
    public boolean unfreeze(ApplicationDTO application) {
        ApplicationPO applicationPO = this.getPoById(application.getId());
        if (applicationPO == null) {
            return false;
        }
        ApplicationPO tmpApp = new ApplicationPO();
        tmpApp.setId(applicationPO.getId());
        tmpApp.setStatus(Integer.valueOf(CommonStatusEnum.ENABLE.getCode()));
        return this.updateById((Object)tmpApp);
    }

    public ApplicationDTO getCacheByCode(String appCode) {
        try {
            ApplicationDTO appBean = (ApplicationDTO)this.cacheFactory.getExpireStringService().getValue("CT:USER:AUTH:APP:CONFIG:" + appCode, ApplicationDTO.class);
            if (appBean == null || CuscStringUtils.isEmpty((String)appBean.getApplicationCode())) {
                appBean = ApplicationConverter.INSTANCE.poToDto(this.getPoByCode(appCode));
                if (appBean == null) {
                    throw new CuscUserException(ResponseCode.APP_CONFIG_INVALID.getCode() + "", ResponseCode.APP_CONFIG_INVALID.getMsg());
                }
                this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:APP:CONFIG:" + appCode, (Object)appBean, 1800);
            }
            return appBean;
        }
        catch (CacheException e) {
            throw new CuscUserException(ResponseCode.REDIS_OPT_FAIL.getCode() + "", ResponseCode.REDIS_OPT_FAIL.getMsg());
        }
    }

    public ApplicationDTO refreshCacheByCode(String appCode) {
        ApplicationDTO appBean = ApplicationConverter.INSTANCE.poToDto(this.getPoByCode(appCode));
        if (appBean == null) {
            throw new CuscUserException(ResponseCode.APP_CONFIG_INVALID.getCode() + "", ResponseCode.APP_CONFIG_INVALID.getMsg());
        }
        try {
            this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:APP:CONFIG:" + appCode, (Object)appBean, 1800);
        }
        catch (CacheException e) {
            throw new CuscUserException(ResponseCode.REDIS_OPT_FAIL.getCode() + "", ResponseCode.REDIS_OPT_FAIL.getMsg());
        }
        return appBean;
    }

    private ApplicationPO getPoById(Long id) {
        return (ApplicationPO)this.getById((Serializable)id);
    }

    private ApplicationPO getPoByCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"application_code", (Object)code);
        queryWrapper.eq((Object)"is_delete", (Object)0);
        return (ApplicationPO)this.getOne((Wrapper)queryWrapper);
    }
}

