/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IUserRoleService;
import com.cusc.nirvana.user.eiam.service.IUserService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userRole"})
public class UserRoleController {
    private static final Logger log = LoggerFactory.getLogger(UserRoleController.class);
    @Autowired
    IUserRoleService userRoleService;
    @Autowired
    IUserService userService;

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u7528\u6237\u89d2\u8272\u4fe1\u606f", notes="\u7528\u6237\u89d2\u8272\u4fe1\u606f")
    public Response add(@RequestBody UserRoleDTO entity) {
        return Response.createSuccess((Object)this.userRoleService.add(entity));
    }

    @PostMapping(value={"/addBatchUserList"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e\u7528\u6237\u89d2\u8272\u4fe1\u606f", notes="\u6279\u91cf\u65b0\u589e\u7528\u6237\u89d2\u8272\u4fe1\u606f")
    public Response addBatchUserList(@RequestBody UserRoleDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getUserId()) || CuscStringUtils.isEmpty((String)entity.getTenantNo()) || CuscStringUtils.isEmpty((String)entity.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.userRoleService.addBatchRole(entity));
    }

    @PostMapping(value={"/delBatchUser"})
    @ApiOperation(value="\u901a\u8fc7\u7528\u6237id\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u7cfb", notes="\u901a\u8fc7\u7528\u6237id\u5220\u9664\u7528\u6237\u89d2\u8272\u5173\u7cfb")
    public Response delBatchUser(@RequestBody UserRoleDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getUserId()) || CuscStringUtils.isEmpty((String)entity.getTenantNo()) || CuscStringUtils.isEmpty((String)entity.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.userRoleService.delBatchUser(entity));
    }

    @PostMapping(value={"/updateByUserId"})
    public Response updateByUserId(@RequestBody UserRoleDTO dto) {
        this.userRoleService.updateByUserId(dto);
        return Response.createSuccess();
    }

    @PostMapping(value={"/queryListByUserIdList"})
    public Response<List<UserRoleDTO>> queryListByUserIdList(@RequestBody UserRoleDTO dto) {
        return Response.createSuccess((Object)this.userRoleService.queryListByUserIdList(dto));
    }

    @PostMapping(value={"/queryByList"})
    public Response<List<UserRoleDTO>> queryByList(@RequestBody UserRoleDTO userRole) {
        return Response.createSuccess((Object)this.userRoleService.queryByList(userRole));
    }
}

