/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.ResourceTempalteDTO;
import com.cusc.nirvana.user.eiam.service.IResourceTempalteService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resourceTempalte"})
public class ResourceTempalteController {
    @Autowired
    private IResourceTempalteService resourceTempalteService;

    @PostMapping(value={"/queryByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<ResourceTempalteDTO>> queryByPage(@RequestBody ResourceTempalteDTO resourceTempalte) {
        return Response.createSuccess((Object)this.resourceTempalteService.queryByPage(resourceTempalte));
    }

    @PostMapping(value={"/getByUuid"})
    public Response<ResourceTempalteDTO> getByUuid(@RequestBody ResourceTempalteDTO resourceTempalte) {
        return Response.createSuccess((Object)this.resourceTempalteService.getByUuid(resourceTempalte));
    }

    @PostMapping(value={"/queryByList"})
    public Response<List<ResourceTempalteDTO>> queryByList(@RequestBody ResourceTempalteDTO resourceTempalte) {
        return Response.createSuccess((Object)this.resourceTempalteService.queryByList(resourceTempalte));
    }

    @PostMapping(value={"/add"})
    public Response add(@RequestBody ResourceTempalteDTO resourceTempalte) {
        this.resourceTempalteService.insert(resourceTempalte);
        return Response.createSuccess();
    }

    @PostMapping(value={"/update"})
    public Response update(@RequestBody ResourceTempalteDTO resourceTempalte) {
        this.resourceTempalteService.update(resourceTempalte);
        return Response.createSuccess();
    }

    @PostMapping(value={"/deleteById"})
    public Response<Boolean> deleteById(@RequestBody ResourceTempalteDTO resourceTempalte) {
        return Response.createSuccess((Object)this.resourceTempalteService.deleteById(resourceTempalte));
    }

    @PostMapping(value={"/queryResourceIdList"})
    public Response<List<String>> queryResourceIdList(@RequestBody ResourceTempalteDTO resourceTempalte) {
        if (CuscStringUtils.isEmpty((String)resourceTempalte.getApplicationId()) || CuscStringUtils.isEmpty((String)resourceTempalte.getRoleCode())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceTempalteService.queryResourceIdList(resourceTempalte));
    }
}

