/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.ResponseCode;
import com.cusc.nirvana.user.eiam.dto.ResourceBatchDTO;
import com.cusc.nirvana.user.eiam.dto.ResourceDTO;
import com.cusc.nirvana.user.eiam.dto.ResourceSimpleDTO;
import com.cusc.nirvana.user.eiam.dto.ResourceTreeDTO;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IResourceService;
import com.cusc.nirvana.user.eiam.service.IRoleService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/resource"})
public class ResourceController {
    private static final Logger log = LoggerFactory.getLogger(ResourceController.class);
    @Autowired
    IResourceService resourceService;
    @Autowired
    IRoleService roleService;

    @PostMapping(value={"/addList"})
    @ApiOperation(value="\u6279\u91cf\u65b0\u589e", notes="\u6279\u91cf\u65b0\u589e")
    public Response addList(@RequestBody ResourceBatchDTO resourceBatch) {
        Response ret = this.resourceService.addList(resourceBatch);
        return ret;
    }

    @PostMapping(value={"/compareResource"})
    @ApiOperation(value="\u6bd4\u5bf9\u8f93\u5165\u548c\u6570\u636e\u5e93\u4e2d\u7684\u8d44\u6e90", notes="\u6bd4\u5bf9\u8f93\u5165\u548c\u6570\u636e\u5e93\u4e2d\u7684\u8d44\u6e90")
    public Response compareResource(@RequestBody List<ResourceTreeDTO> resourceList) {
        this.resourceService.compareResource(resourceList);
        return Response.createSuccess();
    }

    @PostMapping(value={"/query"})
    @ApiOperation(value="\u67e5\u8be2\u8d44\u6e90\u96c6\u5408", notes="\u67e5\u8be2\u8d44\u6e90\u96c6\u5408")
    public Response<List<ResourceSimpleDTO>> query(@RequestBody ResourceDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return this.resourceService.query(entity);
    }

    @PostMapping(value={"/queryResourceByRoleId"})
    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272id\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f", notes="\u901a\u8fc7\u89d2\u8272id\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f")
    public Response<List<ResourceDTO>> queryResourceByRoleId(@RequestBody RoleResourceDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getTenantNo()) || CuscStringUtils.isEmpty((String)entity.getRoleId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceService.queryResourceByRoleId(entity));
    }

    @PostMapping(value={"/queryResourceByUserId"})
    @ApiOperation(value="\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f", notes="\u901a\u8fc7\u7528\u6237id\u67e5\u8be2\u8d44\u6e90\u4fe1\u606f")
    public Response<List<ResourceSimpleDTO>> queryResourceByUserId(@RequestBody UserRoleDTO entity) {
        if (CuscStringUtils.isEmpty((String)entity.getUserId()) || CuscStringUtils.isEmpty((String)entity.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceService.queryResourceByUserId(entity));
    }

    @PostMapping(value={"/queryByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<ResourceDTO>> queryByPage(@RequestBody ResourceDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceService.queryByPage(bean));
    }

    @PostMapping(value={"/getByUuid"})
    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e", notes="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    public Response<ResourceDTO> getByUuid(@RequestBody ResourceDTO bean) {
        return Response.createSuccess((Object)this.resourceService.getByUuid(bean));
    }

    @PostMapping(value={"/add"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e", notes="\u65b0\u589e\u6570\u636e")
    public Response add(@RequestBody ResourceDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getResourceCode()) || CuscStringUtils.isEmpty((String)bean.getResourceName()) || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceService.add(bean));
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u65b0\u589e\u6570\u636e", notes="\u65b0\u589e\u6570\u636e")
    public Response update(@RequestBody ResourceDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getUuid()) || CuscStringUtils.isEmpty((String)bean.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceService.update(bean));
    }

    @PostMapping(value={"/deleteById"})
    @ApiOperation(value="\u5220\u9664\u6570\u636e", notes="\u5220\u9664\u6570\u636e")
    public Response<Boolean> deleteById(@RequestBody ResourceDTO resource) {
        if (CuscStringUtils.isEmpty((String)resource.getUuid()) || CuscStringUtils.isEmpty((String)resource.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceService.deleteById(resource));
    }

    @PostMapping(value={"/frozen"})
    @ApiOperation(value="\u51bb\u7ed3", notes="\u51bb\u7ed3")
    public Response frozen(@RequestBody ResourceDTO resource) {
        if (CuscStringUtils.isEmpty((String)resource.getUuid()) || CuscStringUtils.isEmpty((String)resource.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceService.frozen(resource));
    }

    @PostMapping(value={"/unfreeze"})
    @ApiOperation(value="\u89e3\u51bb", notes="\u89e3\u51bb")
    public Response unfreeze(@RequestBody ResourceDTO resource) {
        if (CuscStringUtils.isEmpty((String)resource.getUuid()) || CuscStringUtils.isEmpty((String)resource.getApplicationId())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        return Response.createSuccess((Object)this.resourceService.unfreeze(resource));
    }

    @PostMapping(value={"/generateResSql"})
    @ApiOperation(value="\u751f\u6210\u8d44\u6e90sql", notes="\u751f\u6210\u8d44\u6e90sql")
    public Response<List<String>> generateResSql(@RequestBody ResourceDTO bean) {
        return Response.createSuccess((Object)this.resourceService.generateResSql(bean));
    }
}

