/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dto.OrganizationDTO;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.eiam.service.IOrganizationService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/organization"})
public class OrganizationController {
    @Autowired
    private IOrganizationService organizationService;

    @PostMapping(value={"/queryByPage"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", notes="\u5206\u9875\u67e5\u8be2")
    public Response<PageResult<OrganizationDTO>> queryByPage(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess((Object)this.organizationService.queryByPage(organization));
    }

    @PostMapping(value={"/getByUuid"})
    public Response<OrganizationDTO> getByUuid(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess((Object)this.organizationService.getByUuid(organization));
    }

    @PostMapping(value={"/queryByList"})
    public Response<List<OrganizationDTO>> queryByList(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess((Object)this.organizationService.queryByList(organization));
    }

    @PostMapping(value={"/add"})
    public Response<OrganizationDTO> add(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess((Object)this.organizationService.insert(organization));
    }

    @PostMapping(value={"/update"})
    public Response update(@RequestBody OrganizationDTO organization) {
        this.organizationService.update(organization);
        return Response.createSuccess();
    }

    @PostMapping(value={"/deleteById"})
    public Response<Boolean> deleteById(@RequestBody OrganizationDTO organization) {
        return Response.createSuccess((Object)this.organizationService.deleteById(organization));
    }

    @PostMapping(value={"/frozen"})
    @ApiOperation(value="\u51bb\u7ed3", notes="\u51bb\u7ed3")
    public Response frozen(@RequestBody OrganizationDTO bean) {
        return Response.createSuccess((Object)this.organizationService.frozen(bean));
    }

    @PostMapping(value={"/unfreeze"})
    @ApiOperation(value="\u89e3\u51bb", notes="\u89e3\u51bb")
    public Response unfreeze(@RequestBody OrganizationDTO bean) {
        return Response.createSuccess((Object)this.organizationService.unfreeze(bean));
    }

    @PostMapping(value={"/getOrganListByUserId"})
    public Response<List<OrganizationDTO>> getOrganListByUserId(@RequestBody UserOrganDTO bean) {
        return Response.createSuccess((Object)this.organizationService.getOrganListByUserId(bean));
    }
}

