/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.ciam.util;

import com.cusc.nirvana.user.util.CuscStringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);

    public static int compareDate(Date date1, Date date2) {
        return date1.compareTo(date2);
    }

    public static int daysBetween(Date beginDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            beginDate = sdf.parse(sdf.format(beginDate));
            endDate = sdf.parse(sdf.format(endDate));
            long time1 = beginDate.getTime();
            long time2 = endDate.getTime();
            long between_days = (time2 - time1) / 86400000L;
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (ParseException e) {
            LOGGER.error("DateUtil.daysBetween error ! ", (Throwable)e);
            return -1;
        }
    }

    public static Date parseDate(String dateStr, String format) {
        if (CuscStringUtils.isEmpty((String)format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            LOGGER.error("DateUtil.parseDate error ! ", (Throwable)e);
            return null;
        }
    }
}

