/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.ciam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.user.ciam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.ciam.converter.UserConverter;
import com.cusc.nirvana.user.ciam.dao.CiamUserDao;
import com.cusc.nirvana.user.ciam.dao.entity.CiamUserPO;
import com.cusc.nirvana.user.ciam.dto.CiamUserDTO;
import com.cusc.nirvana.user.ciam.service.ICiamUserService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.CryptKeyUtil;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CiamUserServiceImpl
extends ServiceImpl<CiamUserDao, CiamUserPO>
implements ICiamUserService {
    @Transactional
    public CiamUserDTO addOrGet(CiamUserDTO bean) {
        if (CuscStringUtils.isEmpty((String)bean.getPhoneNum()) || bean.getTenantNo() == null) {
            return null;
        }
        CiamUserDTO retUser = this.getUserByPhoneTenantNo(bean);
        if (retUser != null && CuscStringUtils.isNotEmpty((String)retUser.getUuid())) {
            return retUser;
        }
        CiamUserPO entity0 = UserConverter.INSTANCE.dtoDataToPo(bean);
        entity0.setUuid(CuscStringUtils.generateUuid());
        bean.setUuid(entity0.getUuid());
        this.save((Object)entity0);
        return bean;
    }

    public CiamUserDTO getUserByPhoneTenantNo(CiamUserDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"phone_num", (Object)CryptKeyUtil.encryptToBase64((String)bean.getPhoneNum()));
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.eq(bean.getStatus() != null, (Object)"status", (Object)bean.getStatus());
        return UserConverter.INSTANCE.poDataToDto((CiamUserPO)this.getOne((Wrapper)queryWrapper));
    }

    public boolean delete(CiamUserDTO bean) {
        CiamUserDTO entity0 = this.get(bean);
        if (entity0 == null) {
            return false;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"uuid", (Object)bean.getUuid());
        updateWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        updateWrapper.set((Object)"is_delete", (Object)CommonDeleteEnum.DELETED.getCode());
        return this.update((Wrapper)updateWrapper);
    }

    public boolean update(CiamUserDTO bean) {
        CiamUserPO userDO = this.getUserDO(bean);
        if (userDO == null) {
            return false;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"uuid", (Object)bean.getUuid());
        updateWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        updateWrapper.eq((Object)"routing_key", (Object)userDO.getRoutingKey());
        updateWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        BeanUtils.copyProperties((Object)bean, (Object)userDO);
        userDO.setUuid(null);
        userDO.setTenantNo(null);
        return this.update((Object)userDO, (Wrapper)updateWrapper);
    }

    public List<CiamUserDTO> query(CiamUserDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc((Object)"create_time");
        List recordList = this.list((Wrapper)queryWrapper);
        return this.transToDTOList(recordList);
    }

    public CiamUserDTO get(CiamUserDTO bean) {
        CiamUserPO userSubjectDO = this.getUserDO(bean);
        CiamUserDTO ret = new CiamUserDTO();
        if (userSubjectDO != null) {
            ret = UserConverter.INSTANCE.poDataToDto(userSubjectDO);
        }
        return ret;
    }

    private CiamUserPO getUserDO(CiamUserDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"uuid", (Object)bean.getUuid());
        queryWrapper.eq((Object)"tenant_no", (Object)bean.getTenantNo());
        queryWrapper.eq((Object)"is_delete", (Object)CommonDeleteEnum.NORMAL.getCode());
        return (CiamUserPO)this.getOne((Wrapper)queryWrapper);
    }

    private List<CiamUserDTO> transToDTOList(List<CiamUserPO> recordList) {
        ArrayList<CiamUserDTO> retList = new ArrayList<CiamUserDTO>();
        if (CollectionUtils.isEmpty(recordList)) {
            return retList;
        }
        for (CiamUserPO bean : recordList) {
            CiamUserDTO userDTO = new CiamUserDTO();
            BeanUtils.copyProperties((Object)bean, (Object)userDTO);
            retList.add(userDTO);
        }
        return retList;
    }
}

