/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.service.impl;

import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.user.auth.identification.service.IRandomIdService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RandomIdServiceImpl
implements IRandomIdService {
    private static final Logger log = LoggerFactory.getLogger(RandomIdServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomIdServiceImpl.class);
    @Autowired
    private CacheFactory cacheFactory;

    public String getRequestIdToRedis(String applicationId, int expireTime, String content) {
        String requestId = CuscStringUtils.generateUuid();
        try {
            this.cacheFactory.getExpireStringService().setExpireValue("CT:USER:AUTH:RANDOM:ID:" + requestId + "_" + applicationId, (Object)content, expireTime);
        }
        catch (CacheException e) {
            log.error("getRequestIdToRedis \u8bf7\u6c42reids\u5931\u8d25 \uff1a", (Throwable)e);
            return null;
        }
        return requestId;
    }

    public boolean existsRequestIdRedis(String requestId, String applicationId) {
        try {
            return this.cacheFactory.getExpireStringService().containsKey("CT:USER:AUTH:RANDOM:ID:" + requestId + "_" + applicationId);
        }
        catch (CacheException e) {
            log.error("getRequestIdToRedis \u8bf7\u6c42reids\u5931\u8d25 \uff1a", (Throwable)e);
            return false;
        }
    }

    public boolean delRequestIdRedis(String requestId, String applicationId) {
        try {
            return this.cacheFactory.getExpireStringService().delete(new String[]{"CT:USER:AUTH:RANDOM:ID:" + requestId + "_" + applicationId});
        }
        catch (CacheException e) {
            log.error("getRequestIdToRedis \u8bf7\u6c42reids\u5931\u8d25 \uff1a", (Throwable)e);
            return false;
        }
    }

    public String getByRequestId(String requestId, String applicationId) {
        try {
            return (String)this.cacheFactory.getExpireStringService().getValue("CT:USER:AUTH:RANDOM:ID:" + requestId + "_" + applicationId, String.class);
        }
        catch (CacheException e) {
            log.error("getByRequestId \u8bf7\u6c42reids\u5931\u8d25 \uff1a", (Throwable)e);
            return null;
        }
    }
}

