/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.identification.login;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.identification.dto.MobileLoginReq;
import com.cusc.nirvana.user.auth.identification.dto.Oauth2Token;
import com.cusc.nirvana.user.auth.identification.service.ILoginService;
import com.cusc.nirvana.user.auth.identification.util.CommonParamterCheck;
import com.cusc.nirvana.user.util.CuscStringUtils;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ciam/login"})
public class CiamLoginController {
    private static final Logger log = LoggerFactory.getLogger(CiamLoginController.class);
    @Autowired
    ILoginService loginService;

    @PostMapping(value={"/mobile"})
    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55", notes="\u624b\u673a\u53f7\u767b\u5f55")
    public Response<Oauth2Token> mobileLogin(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getPhone()) || CuscStringUtils.isEmpty((String)bean.getCaptcha())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        log.info("mobileLogin request url: /user-auth/ciam/login/mobileLogin , phone: {} , captcha: {}", (Object)bean.getPhone(), (Object)bean.getCaptcha().substring(1));
        return this.loginService.ciamMobileLogin(bean);
    }

    @PostMapping(value={"/mobileXP"})
    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55", notes="\u624b\u673a\u53f7\u767b\u5f55")
    public Response<Oauth2Token> mobileLoginXP(@RequestBody MobileLoginReq bean) {
        if (bean == null || CuscStringUtils.isEmpty((String)bean.getPhone())) {
            return Response.createError((String)ResponseCode.PARAMETER_NULL.getMsg(), (Integer)ResponseCode.PARAMETER_NULL.getCode());
        }
        CommonParamterCheck.appIdAndTenantNoRequired((String)bean.getApplicationId(), (String)bean.getTenantNo());
        log.info("mobileLoginXP request url: /user-auth/ciam/login/mobileLogin , phone: {} ", (Object)bean.getPhone());
        return this.loginService.ciamMobileLoginXP(bean);
    }
}

