/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.authentication.service;

import com.cache.CacheFactory;
import com.cache.constants.CacheConstants;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import com.cusc.nirvana.user.auth.common.service.AppConfigService;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    private static final Logger log = LoggerFactory.getLogger(TokenService.class);
    @Autowired
    private CacheFactory cacheFactory;
    @Autowired
    private AppConfigService appConfigService;

    @Async(value="dataToRedisExecutor")
    public void tokenRenewal(Response<AccessTokenHashDTO> ckTokenResp, String accessToken) {
        if (ckTokenResp == null || !ckTokenResp.isSuccess().booleanValue() || ckTokenResp.getData() == null) {
            return;
        }
        AccessTokenHashDTO tokenInfo = (AccessTokenHashDTO)ckTokenResp.getData();
        ApplicationDTO appBean = this.appConfigService.getAppConfigByCode(tokenInfo.getAppId());
        try {
            this.cacheFactory.getExpireHashService().expireKey("CT:USER:AUTH:TOKEN:REFRESH_TOKEN:" + accessToken, appBean.getRenewalTokenTime().intValue(), CacheConstants.TimeType.EX);
            AccessTokenHashDTO accessTokenHashDTO = (AccessTokenHashDTO)this.cacheFactory.getExpireHashService().getHash("CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + accessToken, AccessTokenHashDTO.class);
            if (accessTokenHashDTO != null) {
                this.cacheFactory.getExpireListService().updateExpire("CT:USER:AUTH:TOKEN:USER:" + accessTokenHashDTO.getTenantNo() + ":" + accessTokenHashDTO.getUserId(), appBean.getRenewalTokenTime().intValue());
            }
        }
        catch (CacheException e) {
            log.error("tokenRenewal \u8bbf\u95eereids\u5931\u8d25 key:CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + accessToken + " \u5f02\u5e38:{}", (Throwable)e);
        }
    }
}

