/*
 * Decompiled with CFR 0.152.
 */
package com.cusc.nirvana.user.auth.authentication.service;

import com.cache.CacheFactory;
import com.cache.exception.CacheException;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.auth.authentication.dto.AccessVerifyReq;
import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.auth.common.dto.AccessTokenHashDTO;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AccessAuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessAuthService.class);
    @Autowired
    private CacheFactory cacheFactory;

    public boolean isWhiteList(AccessVerifyReq bean) {
        try {
            return this.cacheFactory.getSetService().containsValue("CT:USER:AUTH:URL:WHITE:LIST", (Object)(bean.getServerName() + bean.getUrl()));
        }
        catch (CacheException e) {
            LOGGER.error("isWhiteList fail ", (Throwable)e);
            return false;
        }
    }

    public Response<AccessTokenHashDTO> checkToken(AccessVerifyReq bean) {
        AccessTokenHashDTO accessTokenHashDTO = this.getTokenInfo(bean);
        if (accessTokenHashDTO == null || CuscStringUtils.isEmpty((String)accessTokenHashDTO.getUserId())) {
            LOGGER.info("checkToken token:{} \u901a\u8fc7token\u83b7\u53d6\u4fe1\u606f\u5931\u8d25", (Object)bean.getToken());
            return Response.createError((String)ResponseCode.TOKEN_INVALID.getMsg(), (Integer)ResponseCode.TOKEN_INVALID.getCode());
        }
        return Response.createSuccess((Object)accessTokenHashDTO);
    }

    public AccessTokenHashDTO getTokenInfo(AccessVerifyReq bean) {
        AccessTokenHashDTO accessTokenHashDTO = null;
        try {
            accessTokenHashDTO = (AccessTokenHashDTO)this.cacheFactory.getExpireHashService().getHash("CT:USER:AUTH:TOKEN:ACCESS_TOKEN:" + bean.getToken(), AccessTokenHashDTO.class);
        }
        catch (CacheException e) {
            LOGGER.error("checkToken \u68c0\u67e5token\u5931\u8d25 :{}", (Throwable)e);
        }
        return accessTokenHashDTO;
    }

    public boolean checkUrlAccess(AccessVerifyReq bean, AccessTokenHashDTO token) {
        String url = bean.getUrl();
        String appId = bean.getAppId();
        String userId = token.getUserId();
        String tenantNo = token.getTenantNo();
        try {
            boolean isPass = this.cacheFactory.getSetService().containsValue("CT:USER:AUTH:URL:USER:" + tenantNo + ":" + userId + "_" + appId, (Object)url);
            if (isPass) {
                return true;
            }
        }
        catch (CacheException e) {
            LOGGER.error("checkUrlAccess fail url:" + url + " , userId:" + userId + " , appId:" + appId + " , tenantNo:" + tenantNo + " ", (Throwable)e);
            return false;
        }
        LOGGER.info("checkUrlAccess url:{} , userId:{} , appId:{} , tenantNo:{} , \u672a\u6388\u6743 ", new Object[]{url, userId, appId, tenantNo});
        return false;
    }
}

