package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cache.CacheFactory;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.eiam.constants.RoleSceneEnum;
import com.cusc.nirvana.user.eiam.converter.UserRoleConverter;
import com.cusc.nirvana.user.eiam.dao.UserRoleDao;
import com.cusc.nirvana.user.eiam.dao.entity.UserRolePO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import com.cusc.nirvana.user.eiam.service.IUrlService;
import com.cusc.nirvana.user.eiam.service.IUserRoleService;
import com.cusc.nirvana.user.util.CuscStringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * <p>
 * 用户角色服务实现类
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
@Service
public class UserRoleServiceImpl extends ServiceImpl<UserRoleDao, UserRolePO> implements IUserRoleService {

    @Autowired
    private CacheFactory cacheFactory;

    @Autowired
    @Lazy
    private IUrlService urlService;

    @Override
    @Transactional
    public UserRoleDTO add(UserRoleDTO bean) {
        //新增
        UserRolePO userRolePO = UserRoleConverter.INSTANCE.dtoToPo(bean);
        this.save(userRolePO);
        //将用户对应的url放到redis
        urlService.userRelRolUrlToRedis(bean.getUserId(), userRolePO.getTenantNo(), userRolePO.getApplicationId());
        return bean;
    }

    @Override
    @Transactional
    public Response addBatchRole(UserRoleDTO entity) {
        //先删除
        deleteByUser(entity);
        List<UserRolePO> urList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(entity.getRoleUuidList())) {
            UserRolePO urDO;
            for (String roleUuid : entity.getRoleUuidList()) {
                urDO = new UserRolePO();
                urDO.setUserId(entity.getUserId());
                urDO.setRoleId(roleUuid);
                urDO.setTenantNo(entity.getTenantNo());
                urDO.setApplicationId(entity.getApplicationId());
                urList.add(urDO);
            }
            //新增
            this.saveBatch(urList);
        }
        //将用户对应的url放到redis
        urlService.userRelRolUrlToRedis(entity.getUserId(), entity.getTenantNo(), entity.getApplicationId());

        return Response.createSuccess(entity.getRoleUuidList().size());
    }

    @Override
    @Transactional
    public Response deleteByUser(UserRoleDTO entity) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq("user_id", entity.getUserId());
        updateWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq("tenant_no", entity.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty(entity.getApplicationId()), "application_id",
                entity.getApplicationId());

        UserRolePO urDO = new UserRolePO();
        urDO.setIsDelete(CommonDeleteEnum.DELETED.getCode());
        urDO.setOperator(entity.getOperator());
        this.update(urDO, updateWrapper);

        //将用户对应的url放到redis
        urlService.userRelRolUrlToRedis(entity.getUserId(), entity.getTenantNo(), entity.getApplicationId());
        return Response.createSuccess(true);
    }

    @Override
    @Transactional
    public Response deleteByRole(UserRoleDTO entity) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq("role_id", entity.getRoleId());
        updateWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq("tenant_no", entity.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty(entity.getApplicationId()), "application_id",
                entity.getApplicationId());

        UserRolePO urDO = new UserRolePO();
        urDO.setIsDelete(CommonDeleteEnum.DELETED.getCode());
        urDO.setOperator(entity.getOperator());
        this.update(urDO, updateWrapper);

        //通过角色将角色对应的url放到redis
        urlService.roleRelUrlToRedis(entity.getRoleId(), RoleSceneEnum.USER.getCode(), entity.getTenantNo(),
                entity.getApplicationId());

        return Response.createSuccess(true);
    }

    @Override
    public Map<String, Set<String>> queryRoleListByUserId(String userId, String tenantNo, String appId) {
        List<UserRolePO> urList = baseMapper.queryRoleListByUserId(userId, tenantNo, appId);
        if (CollectionUtils.isEmpty(urList)) {
            return null;
        }
        Map<String, Set<String>> retMap = new HashMap<>();
        Set<String> roleSet;
        for (UserRolePO tmpBean : urList) {
            //获取当前应用对应的角色
            roleSet = retMap.get(tmpBean.getApplicationId());
            if (roleSet == null) {
                roleSet = new HashSet<>();
                retMap.put(tmpBean.getApplicationId(), roleSet);
            }
            roleSet.add(tmpBean.getRoleId());
        }
        return retMap;
    }

    @Override
    @Transactional
    public boolean delBatchUser(UserRoleDTO entity) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq("user_id", entity.getUserId());
        updateWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        updateWrapper.eq("tenant_no", entity.getTenantNo());
        updateWrapper.eq(CuscStringUtils.isNotEmpty(entity.getApplicationId()), "application_id",
                entity.getApplicationId());
        updateWrapper.in(!CollectionUtils.isEmpty(entity.getUserIdList()), "user_id", entity.getUserIdList());

        UserRolePO urDO = new UserRolePO();
        urDO.setIsDelete(CommonDeleteEnum.DELETED.getCode());
        urDO.setOperator(entity.getOperator());
        this.update(urDO, updateWrapper);

        //通过角色将角色对应的url放到redis
        urlService.roleRelUrlToRedis(entity.getUserId(), RoleSceneEnum.USER.getCode(), entity.getTenantNo(),
                entity.getApplicationId());
        return true;
    }

    @Override
    public void updateByUserId(UserRoleDTO dto) {
        UserRolePO updatePo = new UserRolePO();
        updatePo.setRoleId(dto.getRoleId());
        updatePo.setIsDelete(0);

        LambdaQueryWrapper<UserRolePO> query = new LambdaQueryWrapper<>();
        query.eq(UserRolePO::getUserId, dto.getUserId());
        this.update(updatePo, query);
    }

    @Override
    public List<UserRoleDTO> queryListByUserIdList(UserRoleDTO dto) {
        LambdaQueryWrapper<UserRolePO> query = new LambdaQueryWrapper<>();
        query.in(UserRolePO::getUserId, dto.getUserId());
        List<UserRolePO> list = this.list(query);
        return UserRoleConverter.INSTANCE.poListToDtoList(list);
    }

    /**
     * 通过查询条件查询集合数据
     *
     * @param userRole
     * @return 集合对象
     */
    @Override
    public List<UserRoleDTO> queryByList(UserRoleDTO userRole) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc("create_time");

        queryWrapper.eq("tenant_no", userRole.getTenantNo());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(userRole.getUserId()), "user_id", userRole.getUserId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(userRole.getRoleId()), "role_id", userRole.getRoleId());
        queryWrapper.eq(CuscStringUtils.isNotEmpty(userRole.getApplicationId()), "application_id", userRole.getApplicationId());
        List<UserRolePO> record = this.list(queryWrapper);
        return UserRoleConverter.INSTANCE.poListToDtoList(record);
    }
}
