package com.cusc.nirvana.user.eiam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.rds.mybatis.PageHelper;
import com.cusc.nirvana.user.eiam.converter.DataOperationLogConverter;
import com.cusc.nirvana.user.eiam.dao.DataOperationLogDao;
import com.cusc.nirvana.user.eiam.dao.entity.DataOperationLogPO;
import com.cusc.nirvana.user.eiam.dto.DataOperationLogDTO;
import com.cusc.nirvana.user.eiam.service.IDataOperationLogService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * eiam数据操作历史(DataOperationLog)表服务实现类
 *
 * @author yuy336
 * @since 2022-01-12 15:02:10
 */
@Service
public class DataOperationLogServiceImpl extends ServiceImpl<DataOperationLogDao, DataOperationLogPO> implements IDataOperationLogService {

    /**
     * 通过UUID查询单条数据
     *
     * @param dataOperationLog
     * @return 实例对象
     */
    @Override
    public DataOperationLogDTO getByUuid(DataOperationLogDTO dataOperationLog) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", dataOperationLog.getUuid());
        queryWrapper.eq("is_delete", 0);
        DataOperationLogPO record = this.getOne(queryWrapper);
        return DataOperationLogConverter.INSTANCE.poToDto(record);
    }
    
     /**
     * 通过查询条件查询集合数据
     *
     * @param dataOperationLog
     * @return 集合对象
     */
    @Override
    public List<DataOperationLogDTO> queryByList(DataOperationLogDTO dataOperationLog) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("is_delete", 0);
        queryWrapper.orderByDesc("create_time");
        List<DataOperationLogPO> record = this.list(queryWrapper);
        return DataOperationLogConverter.INSTANCE.poListToDtoList(record);
    }

    /**
     * 分页查询
     *
     * @param dataOperationLog 筛选条件
     * @return 查询结果
     */
    @Override
    public PageResult<DataOperationLogDTO> queryByPage(DataOperationLogDTO dataOperationLog) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByDesc("create_time");
        queryWrapper.eq("is_delete", 0);
        
       Page<DataOperationLogPO> page =
                this.page(new Page<>(dataOperationLog.getCurrPage(), dataOperationLog.getPageSize()), queryWrapper);
        return PageHelper.convert(page, DataOperationLogDTO.class);
    }

    /**
     * 新增数据
     *
     * @param dataOperationLog 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public DataOperationLogDTO insert(DataOperationLogDTO dataOperationLog) {
       DataOperationLogPO dataOperationLogPO = DataOperationLogConverter.INSTANCE.dtoToPo(dataOperationLog);
        this.save(dataOperationLogPO);
        return dataOperationLog;
    }

    /**
     * 修改数据
     *
     * @param dataOperationLog 实例对象
     * @return 实例对象
     */
    @Override
    @Transactional
    public DataOperationLogDTO update(DataOperationLogDTO dataOperationLog) {
        DataOperationLogPO dataOperationLogPO = this.getPoByUuid(dataOperationLog.getUuid());
        this.updateById(dataOperationLogPO);
        return dataOperationLog;
    }

    /**
     * 通过主键删除数据
     * @param dataOperationLog 实例对象
     * @return 是否成功
     */
    @Override
    @Transactional
    public boolean deleteById(DataOperationLogDTO dataOperationLog) {
        DataOperationLogPO dataOperationLogPO = this.getPoByUuid(dataOperationLog.getUuid());
        return this.updateById(dataOperationLogPO);
    }
    
    /**
     * 通过UUID查询单条数据
     *
     * @param uuid
     * @return 实例对象
     */
    private DataOperationLogPO getPoByUuid(String uuid) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", uuid);
        queryWrapper.eq("is_delete", 0);
        return this.getOne(queryWrapper);
    }
}
