package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dao.entity.UrlPO;
import com.cusc.nirvana.user.eiam.dto.EiamUrlDTO;
import com.cusc.nirvana.user.eiam.dto.ResourceUrlSimpleDTO;

import java.util.List;

/**
 * <p>
 * 资源url服务类
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
public interface IUrlService extends IService<UrlPO> {

    /**
     * Description:查询所有资源url
     * <br />
     * CreateDate 2021-10-26 17:42:09
     *
     * @author yuyi
     **/
    Response<List<ResourceUrlSimpleDTO>> queryAll(Integer isAuth);

    /**
     * Description:资源url批量新增
     * <br />
     * CreateDate 2021-10-26 17:40:21
     *
     * @author yuyi
     **/
    Response addList(List<EiamUrlDTO> resourceUrlList);

    /**
     * Description:通过url 和 应用id 查询url对应的id
     * <br />
     * CreateDate 2021-10-26 17:42:09
     *
     * @author yuyi
     **/
    Long queryByUrl(EiamUrlDTO bean);

    /**
     * Description: 白名单信息刷新到redis
     * <br />
     * CreateDate 2021-10-26 17:42:09
     *
     * @author yuyi
     **/
    Integer whiteListToRedis();

    /**
     * Description:新增url
     * <br />
     * CreateDate 2021-10-26 17:40:21
     *
     * @author yuyi
     **/
    Long add(EiamUrlDTO bean);

    /**
     * Description: 将用户授权的url写入redis
     * <br />
     * CreateDate 2022-01-20 17:13:48
     *
     * @author yuyi
     **/
    void userRelUrlToRedis(String userId, String tenantNo, String appId);

    /**
     * Description: 将用户授权的角色url写入redis
     * <br />
     * CreateDate 2022-01-20 17:13:48
     *
     * @author yuyi
     **/
    void userRelRolUrlToRedis(String userId, String tenantNo, String appId);

    /**
     * Description: 将用户授权应用的所有url写入redis
     * <br />
     * CreateDate 2022-01-20 17:13:48
     *
     * @author yuyi
     **/
    void userRelAppUrlToRedis(String userId, String tenantNo);

    /**
     * Description: 删除redis中用户对应的资源集合
     * <br />
     * CreateDate 2022-01-20 17:13:48
     *
     * @author yuyi
     **/
    void delUserRelUrlRedis(String userId, String tenantNo, String appId);

    /**
     * Description: 将角色对应的所有用户url写入redis
     * <br />
     * CreateDate 2022-01-20 17:13:48
     *
     * @author yuyi
     **/
    void roleRelUrlToRedis(String roleId, Integer roleScene, String tenantNo, String appId);

    /**
     * Description: 将用户集合授权的url写入redis
     * <br />
     * CreateDate 2022-01-20 17:13:48
     *
     * @author yuyi
     **/
    void userListRelUrlToRedis(List<String> userIdList, String tenantNo, String appId);

    /**
     * Description: 将租户授权的url写入redis
     * <br />
     * CreateDate 2022-01-20 17:13:48
     *
     * @author yuyi
     **/
    void tenantRelUrlToRedis(String tenantNo, String appId);

}
