package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.user.eiam.dao.entity.DataOperationLogPO;
import com.cusc.nirvana.user.eiam.dto.DataOperationLogDTO;

import java.util.List;

/**
 * eiam数据操作历史(DataOperationLog)表服务接口
 *
 * @author yuy336
 * @since 2022-01-12 15:02:10
 */
public interface IDataOperationLogService extends IService<DataOperationLogPO> {

    /**
     * 通过UUID查询单条数据
     *
     * @param dataOperationLog
     * @return 实例对象
     */
    DataOperationLogDTO getByUuid(DataOperationLogDTO dataOperationLog);
    
     /**
     * 通过查询条件查询集合数据
     *
     * @param dataOperationLog
     * @return 集合对象
     */
    List<DataOperationLogDTO> queryByList(DataOperationLogDTO dataOperationLog);

    /**
     * 分页查询
     *
     * @param dataOperationLog 筛选条件
     * @return 查询结果
     */
    PageResult<DataOperationLogDTO> queryByPage(DataOperationLogDTO dataOperationLog);

    /**
     * 新增数据
     *
     * @param dataOperationLog 实例对象
     * @return 实例对象
     */
    DataOperationLogDTO insert(DataOperationLogDTO dataOperationLog);

    /**
     * 修改数据
     *
     * @param dataOperationLog 实例对象
     * @return 实例对象
     */
    DataOperationLogDTO update(DataOperationLogDTO dataOperationLog);

    /**
     * 通过主键删除数据
     *
     * @param dataOperationLog
     * @return 是否成功
     */
    boolean deleteById(DataOperationLogDTO dataOperationLog);

}
