package com.cusc.nirvana.user.eiam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.user.eiam.dao.entity.ApplicationPO;
import com.cusc.nirvana.user.eiam.dto.ApplicationDTO;

import java.util.List;

/**
 * (Application)表服务接口
 *
 * @author yuy336
 * @since 2022-01-11 17:09:07
 */
public interface IApplicationService extends IService<ApplicationPO> {

    /**
     * 通过UUID查询单条数据
     *
     * @param application
     * @return 实例对象
     */
    ApplicationDTO getById(ApplicationDTO application);
    
     /**
     * 通过查询条件查询集合数据
     *
     * @param application
     * @return 集合对象
     */
    List<ApplicationDTO> queryByList(ApplicationDTO application);

    /**
     * 分页查询
     *
     * @param application 筛选条件
     * @return 查询结果
     */
    PageResult<ApplicationDTO> queryByPage(ApplicationDTO application);

    /**
     * 新增数据
     *
     * @param application 实例对象
     * @return 实例对象
     */
    ApplicationDTO insert(ApplicationDTO application);

    /**
     * 修改数据
     *
     * @param application 实例对象
     * @return 实例对象
     */
    ApplicationDTO update(ApplicationDTO application);

    /**
     * 通过主键删除数据
     *
     * @param application
     * @return 是否成功
     */
    boolean deleteById(ApplicationDTO application);

    /**
     * Description: 冻结
     *
     * @param application
     * @return 是否成功
     **/
    boolean frozen(ApplicationDTO application);

    /**
     * Description: 解冻
     * <br />
     * CreateDate 2021-10-29 15:36:34
     *
     * @author yuyi
     **/
    boolean unfreeze(ApplicationDTO application);

    /**
     * 通过应用code查询缓存
     *
     * @param appCode
     * @return 实例对象
     */
    ApplicationDTO getCacheByCode(String appCode);

    /**
     * 通过应用code刷新缓存
     *
     * @param appCode
     * @return 实例对象
     */
    ApplicationDTO refreshCacheByCode(String appCode);

}
