package com.cusc.nirvana.user.eiam.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.eiam.common.BaseIamPO;

/**
 * <p>
 * 用户角色关系
 * </p>
 *
 * @author yuy336
 * @since 2021-10-20
 */
@TableName("eiam_user_role")
public class UserRolePO extends BaseIamPO {

    /**
     * 用户id
     */
    @TableField("user_id")
    private String userId;

    /**
     * 角色id
     */
    @TableField("role_id")
    private String roleId;

    /**
     * 租户编号
     */
    @TableField("tenant_no")
    private String tenantNo;

    /**
     * 应用id
     */
    @TableField("application_id")
    private String applicationId;

    /**
     * 最后一次操作人
     */
    @TableField("operator")
    private String operator;

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getRoleId() {
        return roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public String getTenantNo() {
        return tenantNo;
    }

    public void setTenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Override
    public String toString() {
        return "UserRolePO{" +
                "userId='" + userId + '\'' +
                ", roleId='" + roleId + '\'' +
                ", tenantNo='" + tenantNo + '\'' +
                ", applicationId='" + applicationId + '\'' +
                ", operator='" + operator + '\'' +
                "} " + super.toString();
    }
}
