package com.cusc.nirvana.user.eiam.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.eiam.common.BaseIamPO;

/**
 * <p>
 *
 * </p>
 * 资源信息
 *
 * @author 资源信息PO
 * @since 2021-10-20
 */
@TableName("eiam_resource")
public class ResourcePO extends BaseIamPO {

    private static final long serialVersionUID = 1L;

    /**
     * 业务主键
     */
    @TableField("uuid")
    private String uuid;

    /**
     * 资源编码
     */
    @TableField("resource_code")
    private String resourceCode;

    /**
     * 资源名称
     */
    @TableField("resource_name")
    private String resourceName;

    /**
     * 资源页面path，定位ui元素使用
     */
    @TableField("resource_ui_path")
    private String resourceUiPath;

    /**
     * 资源对应url
     */
    @TableField("resource_url")
    private String resourceUrl;

    /**
     * 父节点资源
     */
    @TableField("parent_id")
    private String parentId;

    /**
     * 资源类型：0-菜单；1-页面元素
     */
    @TableField("resource_type")
    private Integer resourceType;

    /**
     * 描述
     */
    @TableField("description")
    private String description;

    /**
     * 图标
     */
    @TableField("icon")
    private String icon;

    /**
     * 展示顺序
     */
    @TableField("display_sort")
    private Integer displaySort;

    /**
     * 关联应用
     */
    @TableField("application_id")
    private String applicationId;

    /**
     * 树形结构编码，用于所有子节点搜索
     */
    @TableField("tree_code")
    private String treeCode;

    /**
     * 状态： 0 禁用 1启用
     */
    @TableField("status")
    private Integer status;

    /**
     * 操作人
     */
    @TableField("operator")
    private String operator;

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getResourceCode() {
        return resourceCode;
    }

    public void setResourceCode(String resourceCode) {
        this.resourceCode = resourceCode;
    }

    public String getResourceName() {
        return resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getResourceUiPath() {
        return resourceUiPath;
    }

    public void setResourceUiPath(String resourceUiPath) {
        this.resourceUiPath = resourceUiPath;
    }

    public String getResourceUrl() {
        return resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Integer getResourceType() {
        return resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Integer getDisplaySort() {
        return displaySort;
    }

    public void setDisplaySort(Integer displaySort) {
        this.displaySort = displaySort;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getTreeCode() {
        return treeCode;
    }

    public void setTreeCode(String treeCode) {
        this.treeCode = treeCode;
    }

    @Override
    public String toString() {
        return "ResourcePO{" +
                "uuid='" + uuid + '\'' +
                ", resourceCode='" + resourceCode + '\'' +
                ", resourceName='" + resourceName + '\'' +
                ", resourceUiPath='" + resourceUiPath + '\'' +
                ", resourceUrl='" + resourceUrl + '\'' +
                ", parentId='" + parentId + '\'' +
                ", resourceType=" + resourceType +
                ", description='" + description + '\'' +
                ", icon='" + icon + '\'' +
                ", displaySort=" + displaySort +
                ", applicationId='" + applicationId + '\'' +
                ", status=" + status +
                ", treeCode=" + treeCode +
                ", operator='" + operator + '\'' +
                "} " + super.toString();
    }
}
