package com.cusc.nirvana.user.eiam.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.eiam.common.BaseIamPO;

/**
 * 组织机构(Organization)实体类
 *
 * @author yuy336
 * @since 2022-01-12 14:59:30
 */
@TableName("eiam_organization")
public class OrganizationPO extends BaseIamPO {

    private static final long serialVersionUID = 594976575784937958L;
    
    /**
     * 业务主键
     */    
    @TableField("uuid")
    private String uuid;

    /**
     * 组织场景 0 默认
     */
    @TableField("organ_scene")
    private String organScene;
    
    /**
     * 组织编码
     */    
    @TableField("organ_code")
    private String organCode;
    
    /**
     * 组织姓名
     */    
    @TableField("organ_name")
    private String organName;
    
    /**
     * 组织类型 1 集团 2 公司 3部门 4 组
     */    
    @TableField("organ_type")
    private Integer organType;
    
    /**
     * 上级组织
     */    
    @TableField("parent_id")
    private String parentId;
    
    /**
     * 组织描述
     */    
    @TableField("comment")
    private String comment;
    
    /**
     * 外部id
     */    
    @TableField("third_party_id")
    private String thirdPartyId;
    
    /**
     * 所属省
     */    
    @TableField("province")
    private String province;
    
    /**
     * 所属市
     */    
    @TableField("city")
    private String city;
    
    /**
     * 所属区县
     */    
    @TableField("district")
    private String district;
    
    /**
     * 展示顺序，数字越大越靠前
     */    
    @TableField("display_sort")
    private Integer displaySort;
    
    /**
     * 状态： 0 禁用 1启用
     */    
    @TableField("status")
    private Integer status;
    
    /**
     * 租户编号
     */    
    @TableField("tenant_no")
    private String tenantNo;

    /**
     * 业务类型，由业务系统定义。如车企、经销商等
     */
    @TableField("biz_type")
    private Integer bizType;

    /**
     * 业务类型，由业务系统定义。如车企、经销商等
     */
    @TableField("query_code")
    private String queryCode;
    
    /**
     * 最后一次操作人
     */    
    @TableField("operator")
    private String operator;

	/**
	 * 统一社会信用代码
	 */
	@TableField("unique_code")
	private String uniqueCode;

	/**
	 * 组织简称
	 */
	@TableField("organ_simple_name")
	private String organSimpleName;

	public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getOrganCode() {
        return organCode;
    }

    public void setOrganCode(String organCode) {
        this.organCode = organCode;
    }

    public String getOrganName() {
        return organName;
    }

    public void setOrganName(String organName) {
        this.organName = organName;
    }

    public Integer getOrganType() {
        return organType;
    }

    public void setOrganType(Integer organType) {
        this.organType = organType;
    }

    public String getParentId() {
        return parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getThirdPartyId() {
        return thirdPartyId;
    }

    public void setThirdPartyId(String thirdPartyId) {
        this.thirdPartyId = thirdPartyId;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public Integer getDisplaySort() {
        return displaySort;
    }

    public void setDisplaySort(Integer displaySort) {
        this.displaySort = displaySort;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getTenantNo() {
        return tenantNo;
    }

    public void setTenantNo(String tenantNo) {
        this.tenantNo = tenantNo;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public String getOrganScene() {
        return organScene;
    }

    public void setOrganScene(String organScene) {
        this.organScene = organScene;
    }

    public Integer getBizType() {
        return bizType;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public String getQueryCode() {
        return queryCode;
    }

    public void setQueryCode(String queryCode) {
        this.queryCode = queryCode;
    }

	public String getUniqueCode() {
		return uniqueCode;
	}

	public void setUniqueCode(String uniqueCode) {
		this.uniqueCode = uniqueCode;
	}

	public String getOrganSimpleName() {
		return organSimpleName;
	}

	public void setOrganSimpleName(String organSimpleName) {
		this.organSimpleName = organSimpleName;
	}
}

