package com.cusc.nirvana.user.eiam.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.cusc.nirvana.user.eiam.dao.entity.UrlPO;
import com.cusc.nirvana.user.eiam.dto.EiamUrlDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * ResourceUrlDao
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
public interface UrlDao extends BaseMapper<UrlPO> {

    /**
     * Description: 批量新增资源
     * <br />
     * CreateDate 2021-11-04 17:35:45
     *
     * @author yuyi
     **/
    Integer addResourceUrlBatch(List<EiamUrlDTO> resouceUrlList);

    /**
     * Description: 通过租户编号查询租户角色对应的url
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    Set<String> queryUrlByTenantNo(@Param("tenantNo") String tenantNo, @Param("appId") String appId);

    /**
     * Description: 通过用户id查询用户角色对应的url
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    Set<String> queryRoleUrlByUserId(@Param("userId") String userId, @Param("tenantNo") String tenantNo,
                                     @Param("appId") String appId);

    /**
     * Description: 通过用户id查询用户对应的url
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    Set<String> queryUrlByUserId(@Param("userId") String userId, @Param("tenantNo") String tenantNo,
                                 @Param("appId") String appId);
}
