package com.cusc.nirvana.user.eiam.dao;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.cusc.nirvana.user.eiam.dao.entity.ResourcePO;
import com.cusc.nirvana.user.eiam.dto.ResourceDTO;
import com.cusc.nirvana.user.eiam.dto.RoleResourceDTO;
import com.cusc.nirvana.user.eiam.dto.UserRoleDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * Mapper 接口
 * </p>
 *
 * @author auto-generator
 * @since 2021-10-20
 */
public interface ResourceDao extends BaseMapper<ResourcePO> {

    /**
     * Description: 通过角色id查询资源信息
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    List<ResourcePO> queryResourceByRoleId(RoleResourceDTO entity);

    /**
     * Description: 批量新增资源
     * <br />
     * CreateDate 2021-11-04 17:35:45
     *
     * @author yuyi
     **/
    Integer addResourceBatch(List<ResourcePO> resouceList);

    /**
     * Description: 通过用户id查询资源信息-用户授权
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    List<ResourcePO> queryResourceUserByUserId(UserRoleDTO entity);

    /**
     * Description: 通过用户id查询资源信息-角色授权
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    List<ResourcePO> queryResourceRoleByUserId(UserRoleDTO entity);

    /**
     * Description: 通过应用id查询有效的资源code集合
     * <br />
     * CreateDate 2021-10-29 22:24:25
     *
     * @author yuyi
     **/
    Set<String> queryResourceCodeSet(@Param("appId") String appId);

    /**
     * 生成资源sql
     *
     * @param bean 实体
     * @return sql集合
     */
    List<String> generateResSql(ResourceDTO bean);

}
