package com.cusc.nirvana.user.eiam.controller;

import com.cusc.nirvana.common.result.PageResult;
import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.eiam.dto.UserOrganDTO;
import com.cusc.nirvana.user.eiam.service.IUserOrganService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 用户组织信息(UserOrgan)表控制层
 *
 * @author yuy336
 * @since 2022-01-12 15:00:02
 */
@RestController
@RequestMapping("/userOrgan")
public class UserOrganController {
    /**
     * 服务对象
     */
    @Autowired
    private IUserOrganService userOrganService;

    /**
     * 分页查询
     *
     * @param userOrgan 筛选条件
     * @return 查询结果
     */
    @PostMapping("/queryByPage")
    @ApiOperation(value = "分页查询", notes = "分页查询")
    public Response<PageResult<UserOrganDTO>> queryByPage(@RequestBody UserOrganDTO userOrgan) {
        return Response.createSuccess(userOrganService.queryByPage(userOrgan));
    }

    /**
     * 通过主键查询单条数据
     *
     * @param userOrgan 实体
     * @return 单条数据
     */
   @PostMapping("/getByUuid")
    public Response<UserOrganDTO> getByUuid(@RequestBody UserOrganDTO userOrgan) {
        return Response.createSuccess(this.userOrganService.getByUuid(userOrgan));
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param userOrgan 实体
     * @return 单条数据
     */
   @PostMapping("/queryByList")
    public Response<List<UserOrganDTO>> queryByList(@RequestBody UserOrganDTO userOrgan) {
        return Response.createSuccess(this.userOrganService.queryByList(userOrgan));
    }

    /**
     * 新增数据
     *
     * @param userOrgan 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response add(@RequestBody UserOrganDTO userOrgan) {
       this.userOrganService.insert(userOrgan);
       return Response.createSuccess();
    }

    /**
     * 编辑数据
     *
     * @param userOrgan 实体
     * @return 编辑结果
     */
    @PostMapping("/update")
    public Response update(@RequestBody UserOrganDTO userOrgan) {
        this.userOrganService.update(userOrgan);
        return Response.createSuccess();
    }

    /**
     * 删除数据
     *
     * @param userOrgan 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    public Response<Boolean> deleteById(@RequestBody UserOrganDTO userOrgan) {
        return Response.createSuccess(userOrganService.deleteById(userOrgan));
    }

}

