package com.cusc.nirvana.user.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * Description: 短信相关常量类
 * <br />
 * CreateDate 2021-11-03 20:36
 *
 * @author yuyi
 **/
@Component
public class SmsPropertyConfig {

    //短信的url，默认值是测试环境
    @Value("${sms.cusc.url:https://test-comgr.cu-sc.com:23432/open-api/message}")
    public String smsUrl;

    //短信发送的url
    @Value("${sms.cusc.sendUrl:/sms/v1/send}")
    public String sendUrl;

    //短信发送结果查询的url
    @Value("${sms.cusc.sendResultQueryUrl:/sms/v1/list}")
    public String sendResultQueryUrl;

    @Value("${sms.cusc.version:1.0.0}")
    private String VERSION;

    @Value("${sms.cusc.appid:78F985EE0C6F4418B73013D2B5C48AB2}")
    private String APPID;

    @Value("${sms.cusc.appsecret:6C0768AA4CE64AC3893A0F0F280571A6}")
    private String APPSCRET;

    public String getSmsUrl() {
        return smsUrl;
    }

    public void setSmsUrl(String smsUrl) {
        this.smsUrl = smsUrl;
    }

    public String getSendUrl() {
        return sendUrl;
    }

    public void setSendUrl(String sendUrl) {
        this.sendUrl = sendUrl;
    }

    public String getSendResultQueryUrl() {
        return sendResultQueryUrl;
    }

    public void setSendResultQueryUrl(String sendResultQueryUrl) {
        this.sendResultQueryUrl = sendResultQueryUrl;
    }

    public String getAPPID() {
        return APPID;
    }

    public void setAPPID(String APPID) {
        this.APPID = APPID;
    }

    public String getAPPSCRET() {
        return APPSCRET;
    }

    public void setAPPSCRET(String APPSCRET) {
        this.APPSCRET = APPSCRET;
    }

    public String getVERSION() {
        return VERSION;
    }

    public void setVERSION(String VERSION) {
        this.VERSION = VERSION;
    }
}

