package com.cusc.nirvana.user.ciam.util;

import com.cusc.nirvana.user.ciam.constants.ResponseCode;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;

/**
 * Description: 参数校验工具类
 * <br />
 * CreateDate 2021-11-09 17:42
 *
 * @author yuyi
 **/
public class ParameterCheckUtil {

    /**
     * Description: 检查非空
     * <br />
     * CreateDate 2021-11-09 17:45:25
     *
     * @author yuyi
     **/
    public static void checkNotNull(String parameter) {
        if (CuscStringUtils.isEmpty(parameter)) {
            throw new CuscUserException(ResponseCode.PARAMETER_NOT_NULL.getCode() + "",
                    ResponseCode.PARAMETER_NOT_NULL.getMsg());
        }
    }

    /**
     * Description: 检查非空
     * <br />
     * CreateDate 2021-11-09 17:45:25
     *
     * @author yuyi
     **/
    public static void checkNotNull(String parameter, ResponseCode code) {
        if (CuscStringUtils.isEmpty(parameter)) {
            throw new CuscUserException(code.getCode() + "", code.getMsg());
        }
    }

    /**
     * Description: 检查非空
     * <br />
     * CreateDate 2021-11-09 17:45:25
     *
     * @author yuyi
     **/
    public static void checkNotNull(Integer parameter, ResponseCode code) {
        if (parameter == null) {
            throw new CuscUserException(code.getCode() + "", code.getMsg());
        }
    }

    /**
     * Description: 检查非空
     * <br />
     * CreateDate 2021-11-09 17:45:25
     *
     * @author yuyi
     **/
    public static void checkNotNull(Integer parameter) {
        if (parameter == null) {
            throw new CuscUserException(ResponseCode.PARAMETER_NOT_NULL.getCode() + "",
                    ResponseCode.PARAMETER_NOT_NULL.getMsg());
        }
    }

    /**
     * Description: 检查非空-长整型
     * <br />
     * CreateDate 2021-11-09 17:45:25
     *
     * @author yuyi
     **/
    public static void checkNotNull(Long parameter, ResponseCode code) {
        if (parameter == null) {
            throw new CuscUserException(code.getCode() + "", code.getMsg());
        }
    }

    /**
     * Description: 检查非空-长整型
     * <br />
     * CreateDate 2021-11-09 17:45:25
     *
     * @author yuyi
     **/
    public static void checkNotNull(Long parameter) {
        if (parameter == null) {
            throw new CuscUserException(ResponseCode.PARAMETER_NOT_NULL.getCode() + "",
                    ResponseCode.PARAMETER_NOT_NULL.getMsg());
        }
    }
}
