package com.cusc.nirvana.user.ciam.util;

import com.cusc.nirvana.user.util.CuscStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Description: 时间工具类
 * <br />
 * CreateDate 2021-12-08 16:42
 *
 * @author yuy336
 **/
public class DateUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtil.class);

    /**
     * 比较两个日期的大小
     *
     * @param date1 起始日期
     * @param date2 结束日期
     * @return date1小于date2返回-1，date1大于date2返回1，相等返回0
     */
    public static int compareDate(Date date1, Date date2) {
        return date1.compareTo(date2);
    }

    /**
     * 计算两个日期之间相差的天数
     *
     * @param beginDate 起始日期
     * @param endDate   结束日期
     * @return 相差天数
     */
    public static int daysBetween(Date beginDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            beginDate = sdf.parse(sdf.format(beginDate));
            endDate = sdf.parse(sdf.format(endDate));
            long time1 = beginDate.getTime();
            long time2 = endDate.getTime();
            long between_days = (time2 - time1) / (1000 * 3600 * 24);
            return Integer.parseInt(String.valueOf(between_days));
        } catch (ParseException e) {
            LOGGER.error("DateUtil.daysBetween error ! ", e);
            return -1;
        }
    }

    /**
     * 计算两个日期之间相差的天数
     *
     * @param dateStr 日期天厨
     * @return 日期类型
     */
    public static Date parseDate(String dateStr, String format) {
        if (CuscStringUtils.isEmpty(format)) {
            format = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        try {
            return formatter.parse(dateStr);
        } catch (ParseException e) {
            LOGGER.error("DateUtil.parseDate error ! ", e);
            return null;
        }
    }
}
