package com.cusc.nirvana.user.ciam.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.cusc.nirvana.user.ciam.constants.CiamConstant;
import com.cusc.nirvana.user.ciam.constants.CommonDeleteEnum;
import com.cusc.nirvana.user.ciam.constants.ResponseCode;
import com.cusc.nirvana.user.ciam.converter.UserConverter;
import com.cusc.nirvana.user.ciam.dao.CiamUserDao;
import com.cusc.nirvana.user.ciam.dao.entity.CiamUserPO;
import com.cusc.nirvana.user.ciam.dto.CiamUserDTO;
import com.cusc.nirvana.user.ciam.service.ICiamUserService;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;
import com.cusc.nirvana.user.util.crypt.CryptKeyUtil;
import com.google.common.collect.Lists;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 终端用户 服务实现类
 * </p>
 *
 * @author yuy336
 * @since 2021-10-14
 */
@Service
public class CiamUserServiceImpl extends ServiceImpl<CiamUserDao, CiamUserPO> implements ICiamUserService {

    @Override
    @Transactional
    public CiamUserDTO addOrGet(CiamUserDTO bean) {
        if (CuscStringUtils.isEmpty(bean.getPhoneNum()) || bean.getTenantNo() == null) {
            return null;
        }
        CiamUserPO entity0;
        CiamUserDTO retUser = getUserByPhoneTenantNo(bean);
        if (retUser != null && CuscStringUtils.isNotEmpty(retUser.getUuid())) {
            return retUser;
        }
        //新增用户
        entity0 = UserConverter.INSTANCE.dtoDataToPo(bean);
        entity0.setUuid(CuscStringUtils.generateUuid());
        bean.setUuid(entity0.getUuid());
        this.save(entity0);
        return bean;
    }

    /**
     * Description: 通过手机号查询用户信息
     * <br />
     * CreateDate 2021-11-10 14:28:51
     *
     * @author yuyi
     **/
    @Override
    public CiamUserDTO getUserByPhoneTenantNo(CiamUserDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("phone_num", CryptKeyUtil.encryptToBase64(bean.getPhoneNum()));
        queryWrapper.eq("tenant_no", bean.getTenantNo());
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());

        queryWrapper.eq(bean.getStatus() != null, "status", bean.getStatus());
        return UserConverter.INSTANCE.poDataToDto(this.getOne(queryWrapper));
    }

    @Override
    public boolean delete(CiamUserDTO bean) {
        CiamUserDTO entity0 = this.get(bean);
        if (entity0 == null) {
            return false;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq("uuid", bean.getUuid());
        updateWrapper.eq("tenant_no", bean.getTenantNo());
        updateWrapper.set("is_delete", CommonDeleteEnum.DELETED.getCode());
        return this.update(updateWrapper);
    }

    @Override
    public boolean update(CiamUserDTO bean) {
        CiamUserPO userDO = this.getUserDO(bean);
        if (userDO == null) {
            return false;
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq("uuid", bean.getUuid());
        updateWrapper.eq("tenant_no", bean.getTenantNo());
        updateWrapper.eq("routing_key", userDO.getRoutingKey());
        updateWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());

        BeanUtils.copyProperties(bean, userDO);
        //设置不更新字段
        userDO.setUuid(null);
        userDO.setTenantNo(null);
        return this.update(userDO, updateWrapper);
    }

    @Override
    public List<CiamUserDTO> query(CiamUserDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("tenant_no", bean.getTenantNo());
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        queryWrapper.orderByDesc("create_time");

        List<CiamUserPO> recordList = this.list(queryWrapper);
        return transToDTOList(recordList);
    }

    @Override
    public CiamUserDTO get(CiamUserDTO bean) {
        CiamUserPO userSubjectDO = this.getUserDO(bean);
        CiamUserDTO ret = new CiamUserDTO();
        if (userSubjectDO != null) {
            ret = UserConverter.INSTANCE.poDataToDto(userSubjectDO);
        }
        return ret;
    }

    /**
     * Description: 获取用户do
     * <br />
     * CreateDate 2021-11-10 14:28:51
     *
     * @author yuyi
     **/
    private CiamUserPO getUserDO(CiamUserDTO bean) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq("uuid", bean.getUuid());
        queryWrapper.eq("tenant_no", bean.getTenantNo());
        queryWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
        return this.getOne(queryWrapper);
    }

    /**
     * Description: 将DO集合转为DTO集合
     * <br />
     * CreateDate 2021-11-02 11:49:31
     *
     * @author yuyi
     **/
    private List<CiamUserDTO> transToDTOList(List<CiamUserPO> recordList) {
        List<CiamUserDTO> retList = new ArrayList<>();
        if (CollectionUtils.isEmpty(recordList)) {
            return retList;
        }
        CiamUserDTO userDTO;
        for (CiamUserPO bean : recordList) {
            userDTO = new CiamUserDTO();
            BeanUtils.copyProperties(bean, userDTO);
            retList.add(userDTO);
        }
        return retList;
    }

    ///**
    // * Description: 自助注册，如果有账户就直接登录，没有账户就创建一个账户，然后登录
    // * <br />
    // * CreateDate 2022-04-14 11:49:31
    // *
    // * @author huzl
    // **/
    //@Override
    //public LoginResponseDTO login(LoginRequestDTO loginRequestDTO) {
    //    MobileLoginReq req = new MobileLoginReq();
    //    req.setApplicationId(applicationId);
    //    req.setTenantNo(loginRequestDTO.getTenantNo());
    //    req.setPhone(loginRequestDTO.getPhone());
    //    req.setCaptcha(loginRequestDTO.getSms());
    //
    //    QueryWrapper systemRoutingWrapper = new QueryWrapper();
    //    systemRoutingWrapper.eq("query_key", loginRequestDTO.getPhone());
    //    SystemRoutingPO systemRoutingDO = systemRoutingService.getOne(systemRoutingWrapper);
    //    //账户不存在
    //    if (Objects.isNull(systemRoutingDO)) {
    //        UserPO entity0 = createCiamUser(loginRequestDTO);
    //        //设置UUID
    //        req.setUuid(entity0.getUuid());
    //        //登录
    //        Response<Oauth2Token> response = loginClient.customerMobileLogin(req);
    //        //登录失败 throw exception
    //        if (null == response || !response.isSuccess() || null == response.getData()) {
    //            return null;
    //        }
    //
    //        Oauth2Token data = response.getData();
    //        return new LoginResponseDTO().setAccessToken(data.getAccess_token())
    //                .setRefreshToken(data.getRefresh_token())
    //                .setExpiresIn(data.getExpires_in())
    //                .setLoginName(data.getInfo().getLoginName())
    //                .setNickName(data.getInfo().getNickName())
    //                .setUserId(data.getInfo().getUserId());
    //    }
    //
    //    //查询手机号是否存在
    //    QueryWrapper userWrapper = new QueryWrapper();
    //    userWrapper.eq("phone_num", ciamCryptService.encryptData(loginRequestDTO.getPhone()));
    //    userWrapper.eq("routing_value", systemRoutingDO.getRoutingValue());
    //    userWrapper.eq("tenant_no", loginRequestDTO.getTenantNo());
    //    userWrapper.eq("is_delete", CommonDeleteEnum.NORMAL.getCode());
    //    UserPO userDO = this.getOne(userWrapper);
    //
    //    //帐号不存在
    //    if (Objects.isNull(userDO)) {
    //        UserPO entity0 = createCiamUser(loginRequestDTO);
    //        //设置UUID
    //        req.setUuid(entity0.getUuid());
    //    } else {
    //        //设置UUID
    //        req.setUuid(userDO.getUuid());
    //    }
    //
    //    //登录
    //    Response<Oauth2Token> response = loginClient.customerMobileLogin(req);
    //
    //    //登录失败 throw exception
    //    if (null == response || !response.isSuccess() || null == response.getData()) {
    //        return null;
    //    }
    //
    //    Oauth2Token data = response.getData();
    //    return new LoginResponseDTO().setAccessToken(data.getAccess_token())
    //            .setRefreshToken(data.getRefresh_token())
    //            .setExpiresIn(data.getExpires_in())
    //            .setLoginName(data.getInfo().getLoginName())
    //            .setNickName(data.getInfo().getNickName())
    //            .setUserId(data.getInfo().getUserId());
    //}
}
