package com.cusc.nirvana.user.ciam.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.cusc.nirvana.user.ciam.dao.entity.CiamUserPO;
import com.cusc.nirvana.user.ciam.dto.*;

import java.util.List;

/**
 * <p>
 *  终端用户 服务类
 * </p>
 *
 * @author yuy336
 * @since 2021-10-14
 */
public interface ICiamUserService extends IService<CiamUserPO> {

    /**
     * Description: 添加用户，存在则返回已存在的用户信息
     * <br />
     * CreateDate 2021-11-10 13:58:57
     *
     * @author yuyi
     **/
    CiamUserDTO addOrGet(CiamUserDTO bean);

    /**
     * Description: 删除用户
     * <br />
     * CreateDate 2021-11-10 13:58:57
     *
     * @author yuyi
     **/
    boolean delete(CiamUserDTO bean);

    /**
     * Description: 编辑用户
     * <br />
     * CreateDate 2021-11-10 13:58:57
     *
     * @author yuyi
     **/
    boolean update(CiamUserDTO entity);

    /**
     * Description: 查询用户集合
     * <br />
     * CreateDate 2021-11-10 14:04:10
     *
     * @author yuyi
     **/
    List<CiamUserDTO> query(CiamUserDTO bean);

    /**
     * Description: 查询单个用户
     * <br />
     * CreateDate 2021-11-10 14:03:49
     *
     * @author yuyi
     **/
    CiamUserDTO get(CiamUserDTO bean);

    /**
     * Description: 通过手机号查询用户信息
     * <br />
     * CreateDate 2021-11-10 14:28:51
     *
     * @author yuyi
     **/
    CiamUserDTO getUserByPhoneTenantNo(CiamUserDTO bean);

    ///**
    // * Description: 登录
    // * <br />
    // * CreateDate 2022-04-14 10:07:51
    // *
    // * @author huzl
    // **/
    //LoginResponseDTO login(LoginRequestDTO loginRequestDTO);
}
