package com.cusc.nirvana.user.ciam.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.ciam.common.BaseIamPO;
import lombok.Data;

/**
 * 终端用户三方认证(UserThirdparty)实体类
 *
 * @author yuy336
 * @since 2022-05-05 19:54:47
 */
@TableName("ciam_user_thirdparty")
@Data
public class UserThirdpartyPO extends BaseIamPO {

    private static final long serialVersionUID = 394105662979888841L;
    
    /**
     * 业务主键
     */    
    @TableField("uuid")
    private String uuid;
    
    /**
     * 终端用户id（ciam_user）
     */    
    @TableField("user_id")
    private String userId;
    
    /**
     * 认证类型:1 微信  2 支付宝 3 钉钉
     */    
    @TableField("third_party_type")
    private Integer thirdPartyType;
    
    /**
     * 三方id
     */    
    @TableField("third_party_id")
    private String thirdPartyId;
    
    /**
     * 租户编号
     */    
    @TableField("tenant_no")
    private String tenantNo;
    
    /**
     * 分表路由键
     */    
    @TableField("routing_key")
    private Long routingKey;
    
    /**
     * 最后一次操作人
     */    
    @TableField("operator")
    private String operator;
}

