package com.cusc.nirvana.user.ciam.dao.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.cusc.nirvana.user.ciam.common.BaseIamPO;
import com.cusc.nirvana.user.ciam.dao.handler.EncryptDataTypeHandler;
import lombok.Data;

/**
 * <p>
 * 用户DO
 * </p>
 *
 * @author yuy336
 * @since 2021-10-14
 */
@Data
@TableName(value = "ciam_user", autoResultMap = true)
public class CiamUserPO extends BaseIamPO {

    private static final long serialVersionUID = 1L;

    /**
     * 用户uuid
     */
    @TableField("uuid")
    private String uuid;

    /**
     * 手机号码
     */
    @TableField(value = "phone_num", typeHandler = EncryptDataTypeHandler.class)
    private String phoneNum;

    /**
     * 昵称
     */
    @TableField(value = "nick_name")
    private String nickName;

    /**
     * 头像
     */
    @TableField(value = "head_portrait")
    private String headPortrait;

    /**
     * 租户id
     */
    @TableField("tenant_no")
    private String tenantNo;

    /**
     * 状态
     */
    @TableField("status")
    private Integer status;

    /**
     * 路由值
     */
    @TableField("routing_key")
    private Long routingKey;

    /**
     * 操作人
     */
    @TableField(value = "operator")
    private String operator;
}
