package com.cusc.nirvana.user.ciam.controller;

import com.cusc.nirvana.common.result.Response;
import com.cusc.nirvana.user.ciam.dto.CiamUserThirdpartyDTO;
import com.cusc.nirvana.user.ciam.service.IUserThirdpartyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 终端用户三方认证(UserThirdparty)表控制层
 *
 * @author yuy336
 * @since 2022-05-05 19:54:47
 */
@RestController
@RequestMapping("/userThirdparty")
public class UserThirdpartyController {
    /**
     * 服务对象
     */
    @Autowired
    private IUserThirdpartyService userThirdpartyService;

    /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
   @PostMapping("/getByUuid")
    public Response<CiamUserThirdpartyDTO> getByUuid(@RequestBody CiamUserThirdpartyDTO bean) {
        return Response.createSuccess(userThirdpartyService.getByUuid(bean));
    }
    
     /**
     * 通过主键查询单条数据
     *
     * @param bean 实体
     * @return 单条数据
     */
   @PostMapping("/queryByList")
    public Response<List<CiamUserThirdpartyDTO>> queryByList(@RequestBody CiamUserThirdpartyDTO bean) {
        return Response.createSuccess(userThirdpartyService.queryByList(bean));
    }

    /**
     * 新增数据
     *
     * @param bean 实体
     * @return 新增结果
     */
    @PostMapping("/add")
    public Response add(@RequestBody CiamUserThirdpartyDTO bean) {
       return Response.createSuccess(userThirdpartyService.insert(bean));
    }

    /**
     * 编辑数据
     *
     * @param bean 实体
     * @return 编辑结果
     */
    @PostMapping("/update")
    public Response update(@RequestBody CiamUserThirdpartyDTO bean) {
        return Response.createSuccess(userThirdpartyService.update(bean));
    }

    /**
     * 删除数据
     *
     * @param bean 实体
     * @return 删除是否成功
     */
    @PostMapping("/deleteById")
    public Response<Boolean> deleteById(@RequestBody CiamUserThirdpartyDTO bean) {
        return Response.createSuccess(userThirdpartyService.deleteById(bean));
    }

}

