package com.cusc.nirvana.user.ciam.constants;

public enum ResponseCode {
    USER_SUBJECT_INVALID(1701,""),
    CIAM_ROUTING_KEY_FAIL(1701,"获取路由键失败"),
    COMPANY_UUID_INVALID(1702,"项目关联的公司信息无效"),
    USER_INVALID(1703,"用户信息无效"),
    SUBJECT_CUSTOMER_INFO_INVALID(1704,"主体实名信息无效"),
    USER_PHONE_REPEAT(1705,"用户手机号重复"),
    SUBJECT_CUSTOMER_INFO_NOT_FOUND(1706,"未找到主体实名信息"),
    ENCRYPT_FAIL(1707,"加密失败"),
    DECRYPT_FAIL(1708,"解密失败"),
    REPEAT_REQUEST_FAIL(1709,"请勿重复提交"),


    INVALID_DATA(1001, "数据校验不通过"),
    SYS_BUSY(1002, "服务调用失败"),
    SERVICE_NOT_FOUND(1003, "服务不存在"),
    TP_SYS_BUSY(1004, "第三方服务调用失败"),
    JSON_FORMAT_ERROR(1005, "参数格式错误"),
    REQ_TOO_MANY_TIMES(1007, "请求过于频繁，请稍后再试!"),
    NO_DATA_AUTH(1008, "服务，请稍后再试!"),
    PARAMETER_NOT_NULL(1009, "参数不能为空!"),
    ;

    private Integer code;
    private String msg;

    ResponseCode(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}
