package com.cusc.nirvana.user.auth.identification.util;

import com.cusc.nirvana.user.auth.common.constants.ResponseCode;
import com.cusc.nirvana.user.exception.CuscUserException;
import com.cusc.nirvana.user.util.CuscStringUtils;

/**
 * Description: 参数校验
 * <br />
 * CreateDate 2022-02-17 10:52
 *
 * @author yuy336
 **/
public class CommonParamterCheck {

    /**
     * Description: 检查应用和租户是否为空
     * <br />
     * CreateDate 2022-02-17 10:55:16
     *
     * @author yuyi
     **/
    public static void appIdAndTenantNoRequired(String applicationId, String tenantNo) {
        if (CuscStringUtils.isEmpty(applicationId) || CuscStringUtils.isEmpty(tenantNo)) {
            throw new CuscUserException(ResponseCode.APPLICATION_TENANT_REQUIRED.getCode(),
                    ResponseCode.APPLICATION_TENANT_REQUIRED.getMsg());
        }
    }
}
